% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{transmute.flowSet}
\alias{transmute.flowSet}
\title{Create, modify, and delete columns.}
\usage{
\method{transmute}{flowSet}(.data, ...)
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowSet}}}

\item{...}{Name-value pairs. The name (the left side of the equals sign)
gives the name of the column in the output. The right side of the equation
performs computations using the names of each channel according to the
 \code{\link[flowCore]{featureNames}} of .data's constituent
 \code{\link[flowCore]{flowFrame}}s. Supports tidyselection.}
}
\value{
A \code{\link[flowCore]{flowSet}}. The output has the following properties:
* Columns created or modified through ... will be returned in the order specified by ....
* The number of rows is not affected.
* Columns given the value NULL will be removed.
* The \code{\link[flowCore]{flowSet}}'s \code{\link[Biobase]{pData}} will be preserved.
}
\description{
Create, modify, and delete columns.
}
\examples{
my_flowset <- simulate_cytometry_data()$flowset

my_flowset |>
  dplyr::transmute(new_feature = feature_1 + feature_2)


}
