% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand-CoverageExperiment}
\alias{expand-CoverageExperiment}
\alias{expand.CoverageExperiment}
\title{Expand a CoverageExperiment object}
\usage{
\method{expand}{CoverageExperiment}(data, ..., .name_repair = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{...}{<\code{\link[tidyr:tidyr_data_masking]{data-masking}}> Specification of columns
to expand or complete. Columns can be atomic vectors or lists.
\itemize{
\item To find all unique combinations of \code{x}, \code{y} and \code{z}, including those not
present in the data, supply each variable as a separate argument:
\code{expand(df, x, y, z)} or \code{complete(df, x, y, z)}.
\item To find only the combinations that occur in the
data, use \code{nesting}: \code{expand(df, nesting(x, y, z))}.
\item You can combine the two forms. For example,
\code{expand(df, nesting(school_id, student_id), date)} would produce
a row for each present school-student combination for all possible
dates.
}

When used with factors, \code{\link[tidyr:expand]{expand()}} and \code{\link[tidyr:complete]{complete()}} use the full set of
levels, not just those that appear in the data. If you want to use only the
values seen in the data, use \code{forcats::fct_drop()}.

When used with continuous variables, you may need to fill in values
that do not appear in the data: to do so use expressions like
\code{year = 2010:2020} or \code{year = full_seq(year,1)}.}

\item{.name_repair}{One of \code{"check_unique"}, \code{"unique"}, \code{"universal"},
\code{"minimal"}, \code{"unique_quiet"}, or \code{"universal_quiet"}. See \code{\link[vctrs:vec_as_names]{vec_as_names()}}
for the meaning of these options.}
}
\value{
a \code{tibble} object
}
\description{
A \code{CoverageExperiment} object can be coerced into a \code{tibble} using the
\code{tidySummarizedExperiment} package, but this will not turn
each coverage matrix into a "long" format. The \code{expand} function
provided here allows one to coerce a \code{CoverageExperiment}
object into a long data frame, and adds the \code{ranges}
and \code{seqnames} to the resulting \code{tibble}.
}
\section{Grouped data frames}{


With grouped data frames created by \code{\link[dplyr:group_by]{dplyr::group_by()}}, \code{expand()} operates
\emph{within} each group. Because of this, you cannot expand on a grouping column.

}

\examples{
data(ce)
ce
expand(ce)
}
\seealso{
\code{\link[tidyr:complete]{complete()}} to expand list objects. \code{\link[tidyr:expand_grid]{expand_grid()}}
to input vectors rather than a data frame.
}
