% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terraTCGAdata.R
\name{terraTCGAdata}
\alias{terraTCGAdata}
\title{Obtain a MultiAssayExperiment from the Terra workspace}
\usage{
terraTCGAdata(
  clinicalName,
  assays,
  participants = TRUE,
  sampleCode = NULL,
  split = FALSE,
  workspace = terraTCGAworkspace(),
  namespace = .DEFAULT_NAMESPACE,
  tablename = .DEFAULT_TABLENAME,
  verbose = TRUE,
  sampleIdx = TRUE
)
}
\arguments{
\item{clinicalName}{character(1) The column name taken from
\code{getClinicalTable()} and downloaded to be included as the \code{colData}.}

\item{assays}{character() A character vector of assay names taken from
\code{getAssayTable()}}

\item{participants}{logical(1) Whether to merge the participant table
from \code{avtable("participant")} to the clinical data}

\item{sampleCode}{character() A character vector of sample codes from
\code{sampleTypesTable()}. By default, (NULL) all samples are downloaded and
kept in the data.}

\item{split}{logical(1L) Whether or not to split the \code{MultiAssayExperiment}
by sample types using \code{splitAssays} helper function (default FALSE).}

\item{workspace}{character(1) The Terra Data Resources workspace from which
to pull TCGA data (default: see \code{terraTCGAworkspace()}). This is set to a
package-wide option.}

\item{namespace}{character(1) The Terra Workspace Namespace that
defaults to "broad-firecloud-tcga" and rarely needs to be changed.}

\item{tablename}{The Terra data model table from which to extract the
clinical data (default: "sample")}

\item{verbose}{logical(1) Whether to output additional information regarding
the workspace and namespace (default: \code{TRUE}).}

\item{sampleIdx}{numeric() index or TRUE. Specify an index for subsetting the
assay data. This argument is mainly used for example and vignette
purposes. To use all the data, use the default value (default: \code{TRUE})}
}
\value{
A \code{MultiAssayExperiment} object with n number of assays corresponding
to the \code{assays} argument.
}
\description{
Workspaces on Terra come pre-loaded with TCGA Data. The examples in the
documentation correspond to the TCGA_COAD_OpenAccess_V1 workspace that
can be found on \url{app.terra.bio}.
}
\examples{
if (
    GCPtools::gcloud_exists() &&
    identical(AnVILBase::avplatform_namespace(), "AnVILGCP")
)
  terraTCGAdata(
      clinicalName = "clin__bio__nationwidechildrens_org__Level_1__biospecimen__clin",
      assays = c("protein_exp__mda_rppa_core__mdanderson_org__Level_3__protein_normalization__data",
      "rnaseqv2__illuminahiseq_rnaseqv2__unc_edu__Level_3__RSEM_genes_normalized__data"),
      workspace = "TCGA_COAD_OpenAccess_V1-0_DATA",
      sampleCode = NULL,
      sampleIdx = 1:4,
      split = FALSE
  )

}
