% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinical.R
\name{getClinical}
\alias{getClinical}
\title{Obtain clinical data}
\usage{
getClinical(
  columnName,
  participants = TRUE,
  tablename = .DEFAULT_TABLENAME,
  workspace = terraTCGAworkspace(),
  namespace = .DEFAULT_NAMESPACE,
  verbose = TRUE,
  metacols = .PARTICIPANT_METADATA_COLS,
  participantIds = NULL
)
}
\arguments{
\item{columnName}{The name of the column to extract files, see
\code{getClinicalTable} table. If not provided, the first column in the table
will be used to obtain the clinical information.}

\item{participants}{logical(1) Whether to merge the participant table
from \code{avtable("participant")} to the clinical data}

\item{tablename}{The Terra data model table from which to extract the
clinical data (default: "sample")}

\item{workspace}{character(1) The Terra Data Resources workspace from which
to pull TCGA data (default: see \code{terraTCGAworkspace()}). This is set to a
package-wide option.}

\item{namespace}{character(1) The Terra Workspace Namespace that
defaults to "broad-firecloud-tcga" and rarely needs to be changed.}

\item{verbose}{logical(1) Whether to output additional information regarding
the workspace and namespace (default: \code{TRUE}).}

\item{metacols}{The set of columns that comprise of the metadata columns.
See the \code{.PARTICIPANT_METADATA_COLS} global variable}

\item{participantIds}{character() TCGA participant identifiers usually in the
form of "TCGA-AB-1234". By default, all available participant identifiers
will be used. (default: \code{NULL})}
}
\value{
A \code{DataFrame} with clinical information from TCGA. The metadata i.e.,
\code{metadata(object)} includes the \code{columnName} used to obtain the data.
}
\description{
The participant table may contain curated demographic information e.g.,
sex, age, etc.
}
\examples{
if (
    GCPtools::gcloud_exists() &&
    identical(AnVILBase::avplatform_namespace(), "AnVILGCP") &&
    nzchar(AnVILGCP::avworkspace_name())
)
  getClinical(
      workspace = "TCGA_ACC_OpenAccess_V1-0_DATA",
      participantIds = c("TCGA-OR-A5J1", "TCGA-OR-A5J2",
          "TCGA-OR-A5J3", "TCGA-OR-A5J4")
  )

}
