% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terapadogBricks.R
\name{gsScoreFun}
\alias{gsScoreFun}
\title{Compute Gene Set Scores after Translational Efficiency Analysis}
\usage{
gsScoreFun(
  G,
  block,
  ite,
  exp_de,
  esetm,
  paired,
  grouped_indexes,
  minG,
  bigG,
  gf,
  combidx,
  deINgs,
  gslistINesetm
)
}
\arguments{
\item{G}{A factor vector representing the group for each sample.}

\item{block}{A factor indicating paired samples.}

\item{ite}{Integer, indicating the current iteration number.}

\item{exp_de}{A dataframe containing metadata for each sample, including grouping information.}

\item{esetm}{A matrix containing RNA and RIBO count data, where rows correspond to genes and columns to samples.}

\item{paired}{Logical, indicating whether the study design is paired.}

\item{grouped_indexes}{A dataframe mapping RNA and RIBO samples to their corresponding indices.}

\item{minG}{A character value representing the smallest group.}

\item{bigG}{A character vector representing the larger group.}

\item{gf}{A vector containing gene weighting factors.}

\item{combidx}{A matrix storing all possible permutations for group shuffling.}

\item{deINgs}{A vector with genes that are both in the gene sets, as well in esetm.}

\item{gslistINesetm}{A list of indices mapping genes existing both in gslist and esetm.}
}
\value{
A named matrix containing two rows:
\describe{
  \item{MeanAdjP}{Mean adjusted p-value for each gene set.}
  \item{WeightedAdjP}{Weighted adjusted p-value incorporating gene weighting factors.}
}
}
\description{
This internal function performs gene set scoring by applying a modified
version of the PADOG algorithm to genes undergoing changes in translational efficiency.
As reported by the results of the DeltaTE package
}
\details{
The function performs differential translational analysis using DESeq2 and calculates gene set scores
based on adjusted p-values from the differential analysis.
}
\keyword{internal}
