% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_Regmode.R
\name{assign_Regmode}
\alias{assign_Regmode}
\title{This function reads the results of the function getFCs and assigns a
regulatory mode to each gene based on the Fold Change (FC) for RNA-Seq Counts,
Ribo-Seq Counts, or TE. It is intended for internal use and its output is
the output of get_FCs.R}
\usage{
assign_Regmode(res_df)
}
\arguments{
\item{res_df}{A dataframe, output of the function getFCs}
}
\value{
A dataframe, with two extra columns with info on the Regulatory Mode
}
\description{
This function reads the results of the function getFCs and assigns a
regulatory mode to each gene based on the Fold Change (FC) for RNA-Seq Counts,
Ribo-Seq Counts, or TE. It is intended for internal use and its output is
the output of get_FCs.R
}
\examples{
# Internal function, code cannot be run from here.
\dontrun{
mockdata <- data.frame(
  Identifier = c("ENSG00000248713", "ENSG00000125780"),
  log2FoldChange = c(-0.69, 2),
  padj = c(0.16, 0.001),
  RIBO_FC = c(0.27, 3),
  RIBO_padj = c(0.45, 0.002),
  RNA_FC = c(1, 0.56),
  RNA_padj = c(0.001, 0.65)
)
result <- assign_Regmode(mockdata)
# Only the head of the result file will be returned
print(head(result))
}
}
\keyword{internal}
