\name{loadWorkflow}
\alias{loadWorkflow}
\alias{loadWF}
\alias{renderWF}
\alias{updateWF}
\title{
Constructs SYSargs2 object from CWL param and targets files
}
\description{
The constructor functions create an \code{SYSargs2} S4 class object from three 
input files: a \code{CWL param} and \code{input} files, and one simple tabular 
or yml file, a \code{targets} file. The latter is optional for workflow steps 
lacking input files. The\code{CWL param} provides all the parameters required 
for running command-line software, following the standard and specification 
defined on \href{https://www.commonwl.org/}{Common Workflow Language (CWL)}. 
The \code{input} file provides additional information for the command-line, 
allowing each sample level input/outfile operation uses its own \code{SYSargs2} 
instance. In the \code{targets} file users could provide the paths to the initial 
sample input files (e.g. FASTQ) along with sample labels, and if appropriate 
biological replicate and contrast information for controlling differential 
abundance analyses.

The \code{renderWF} function populates all the command-line for each sample in 
each step of the particular workflow. Each sample level input/outfile operation 
uses its own \code{SYSargs2} instance. The output of \code{SYSargs2} define all 
the expected output files for each step in the workflow, which usually it is the
sample input for the next step in an \code{SYSargs2} instance. 
By chaining several \code{SYSargs2} steps together one can construct complex 
workflows involving many sample-level input/output file operations with any 
combination of command-line or R-based software. Between different instances, 
this connectivity is established by \code{`appendStep<-`} method. Please 
check more details from \code{\link{SYSargsList-class}} class.
}
\usage{
loadWorkflow(targets = NULL, wf_file, input_file, dir_path = "param/cwl", id = "SampleName")

renderWF(WF, inputvars = NULL)

updateWF(WF, write.yaml=FALSE, name.yaml="default", new_targets=NULL,
                     new_targetsheader=NULL, inputvars=NULL, silent=FALSE)
}
\arguments{
  \item{targets}{
  either the path to \code{targets} file or an object of \code{SummarizedExperiment} class.
  The \code{targets} file can be either a simple tabular or yml file. Also,
  it is possible to assign \code{NULL} to run the pipeline without the 'targets'
  file. This can be useful for running specific workflows that do not require input files.
}
  \item{wf_file}{
  name and path to \code{CWL parameters} file.
}
  \item{input_file}{
  name and path to \code{input parameters} file.
}
  \item{dir_path}{
  path to the \code{parameters} directory with the \code{wf_file} and 
  \code{input_file} files.
  It is recommended to keep both files in the same directory. 
}
  \item{id}{
  A column from \code{targets} file, which will be used as an id for each one
  of the samples. It is required to be unique.
  }
  \item{WF}{
  Object of class \code{SYSargs2}, generated by \code{loadWF} .
}
  \item{inputvars}{
  named character vector. Variables defined in the \code{input} file that matches 
  the column names defined in the \code{targets} file.
}
  \item{write.yaml}{
  logical. If set to \code{TRUE}, it will write to file the content of the 
  CWL files: \code{*.yml}. Default is \code{FALSE}.
}
  \item{name.yaml}{
   name and path to \code{input parameters} file, if \code{write.yaml} is set to
   \code{TRUE}. Default value will write a file at the same directory of 
   \code{dir_path} appending to the file name the current date.
}
  \item{new_targets}{
  new targets files as list. 'targets' \code{data.frame} can be converted by 
  \code{targets.as.list} function. Default is \code{NULL}, 
  and it will maintain the original.
}
  \item{new_targetsheader}{
  character. New header/comment lines of targets file. Default is \code{NULL}, 
  and it will maintain the original.
}
  \item{silent}{
  If set to \code{TRUE}, all messages returned by the function will be suppressed.
}
}
\value{
\code{SYSargs2} object.
}
\author{
Daniela Cassol and Thomas Girke
}
\seealso{
\code{showClass("SYSargs2")}
}
\examples{
## Construct SYSargs2 object from CWl param, CWL input, and targets files 
targets <- system.file("extdata", "targets.txt", package="systemPipeR")
dir_path <- system.file("extdata/cwl", package="systemPipeR")
WF <- loadWorkflow(targets=targets, wf_file="hisat2/hisat2-mapping-se.cwl", 
                  input_file="hisat2/hisat2-mapping-se.yml", dir_path=dir_path)
WF <- renderWF(WF, inputvars=c(FileName="_FASTQ_PATH1_", SampleName="_SampleName_"))
WF

## If required to update the object
yamlinput(WF, "thread")  <- 6L
WF <- updateWF(WF)
cmdlist(WF)[1]
yamlinput(WF)$thread
}
\keyword{ utilities }
