% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_synergy_score.R
\name{.Distance}
\alias{.Distance}
\title{Calculate Distance from a Point to a Plane}
\usage{
.Distance(w, b, point)
}
\arguments{
\item{w}{A numeric vector. It contains the parameters for all the coordinates
in the spaces to define the "plan".}

\item{b}{A numeric value. It is the constant values in the formula which
defines the "plane".}

\item{point}{A numeric vector. It contains the coordinates in
the spaces to define the "point".}
}
\value{
A numeric value. It is the distance from point defined by \code{x0}
  to the "plane" defined by \code{w} and \code{b}
}
\description{
This function is used to calculate the distance from a point to a plane. It
could also be used in high dimension spaces. The formula comes from
https://en.wikipedia.org/wiki/Distance_from_a_point_to_a_plane
For two dimension point, the distance to the line w1\*x+w2\*y+b = 0
For three dimension point, the distance to the plan w1\*x+w2\*y+w3\*z+b = 0
}
\author{
\itemize{
    \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
    \item Jing Tang \email{jing.tang@helsinki.fi}
 }
}
