% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reshape_data.R
\name{ReshapeData}
\alias{ReshapeData}
\title{Pre-process the Response Data for Further Calculation and Plot}
\usage{
ReshapeData(
  data,
  impute = TRUE,
  impute_method = NULL,
  noise = FALSE,
  seed = NULL,
  iteration = 10,
  data_type = "viability"
)
}
\arguments{
\item{data}{drug combination response data in a data frame format}

\item{impute}{a logical value. If it is \code{TRUE}, the \code{NA} values
will be imputed by \code{\link[mice]{mice}}. Default is \code{TRUE}.}

\item{impute_method}{a single string. It sets the \code{method} parameter
in function \code{\link[mice]{mice}} to specify the imputation method. 
Please check the documentation of \code{\link[mice]{mice}} to find the
available methods.}

\item{noise}{a logical value. It indicates whether or not adding noise to
to the "response" values in the matrix. Default is \code{TRUE}.}

\item{seed}{a single value, interpreted as an integer, or NULL. It is the
random seed for calculating the noise and missing value imputation.
Default setting is \code{NULL}}

\item{iteration}{An integer. It indicates the number of iterations for
bootstrapping while calculating statistics for data with replicates.}

\item{data_type}{a parameter to specify the response data type which can be
either "viability" or "inhibition".}
}
\value{
a list of the following components:
  \itemize{
    \item \strong{drug_pairs} A data frame contains the name of all the
    tested drugs, concentration unit, block IDs and a logical column 
    "replicate" to indicate whether there are replicates in the corresponding
    block.
    \item \strong{response} A data frame contains the columns: "concX" 
    concentrations for drugs from input data; "response_origin" response
    values from input data; "response" \% inhibition value for downstream
    analysis.
  \item \strong{response_statistics} A data frame. It will be output if
    there is block have replicated response values. It contains the
    block ID, the concentrations for all the tested drugs, and statistics for
    \% inhibition values across replicates (including mean, standard
    deviation, standard error of mean and 95\% confidence interval).
  }
}
\description{
A function to transform the response data from data frame format to
dose-response matrices. Several processes could be chose to add noise, impute
missing values or correct base line to the dose-response matrix.
}
\details{
The input data must contain the following columns:
(block_id/BlockId/PairIndex), (drug_row/DrugRow/Drug1),
(drug_col/DrugCol/Drug2), (response/Response/inhibition/Inhibition),
(conc_r/ConcRow/Conc1), (conc_c/ConcCol/Conc2), and
(ConcUnit/conc_r_unit, conc_c_unit/ConcUnit1, ConcUnit2, ConcUnit3)
}
\examples{
data("mathews_screening_data")
# set a random number seed for generating the noises
data <- ReshapeData(mathews_screening_data, seed = 1)
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
