% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_multi_drugs.R
\name{PlotMultiDrugBar}
\alias{PlotMultiDrugBar}
\title{Bar Plot for Multi-drug Combination Dose-Response/Synergy Scores}
\usage{
PlotMultiDrugBar(
  data,
  plot_block = 1,
  plot_value = c("response", "response_origin"),
  sort_by = "response",
  highlight_row = NULL,
  pos_value_color = "#CC3311",
  neg_value_color = "#448BD4",
  highlight_pos_color = "#A90217",
  highlight_neg_color = "#2166AC",
  panel_title_size = 10,
  axis_text_size = 10,
  highlight_label_size = 5,
  data_table = FALSE
)
}
\arguments{
\item{data}{A list object generated by function \code{\link{ReshapeData}}.}

\item{plot_block}{A character/integer. It indicates the block ID for the
block to visualize.}

\item{plot_value}{A vector of characters. It contains the name of one or more
metrics to be visualized. If the \code{data} is the direct output from 
\link{ReshapeData}, the values for this parameter are:
\itemize{
  \item \strong{response_origin} The original response value in input data.
  It might be \% inhibition or \% viability.
  \item \strong{response} The \% inhibition after preprocess by function 
  \link{ReshapeData}
}
If the \code{data} is the output from \link{CalculateSynergy}, following
values are also available:
\itemize{
  \item \strong{ZIP_ref, Bliss_ref, HSA_ref, Loewe_ref} The reference
  additive effects calculated by ZIP, Bliss, HSA or Loewe model,
  respectively.
  \item \strong{ZIP_synergy, Bliss_synergy, HSA_synergy, Loewe_synergy}
  The synergy score calculated by ZIP, Bliss, HSA or Loewe model,
  respectively.
  \item \strong{ZIP_fit} The response fitted by ZIP model.
}}

\item{sort_by}{A character. It indicates by which metric the bars (data 
points) will be sorted. It could be one of the available values for
\code{plot_value} or one of the concentration columns (e.g. "cocn1",
"conc2", ...)}

\item{highlight_row}{A vector of numeric values with the length same as the
number of drugs in selected block. It contains the concentrations  for
"drug1", "drug2", ... The data point selected by these concentrations will
be highlighted in the plot.}

\item{pos_value_color}{An R color value. It indicates the color for the
positive values.}

\item{neg_value_color}{An R color value. It indicates the color for the
negative values.}

\item{highlight_pos_color}{An R color value. It indicates the highlight color
for the positive values.}

\item{highlight_neg_color}{An R color value. It indicates the highlight color
for the negative values.}

\item{panel_title_size}{A numeric value. It indicates the size of panel 
titles in unit "mm".}

\item{axis_text_size}{A numeric value. It indicates the size of axis texts
in unit "mm".}

\item{highlight_label_size}{A numeric value. It indicates the size of the
labels for highlighted rows in unit "mm".}

\item{data_table}{A logic value. If it is \code{TRUE}, the data frame used
for plotting will be output.}
}
\value{
A ggplot object. If \code{data_table = TRUE}, the output will be a
  list containing a ggplot object and a data frame used for plotting.
}
\description{
This function will generate a group of bar plots for one drug combination
block. Each panel (columns) visualize the concentrations for all the drugs 
and metrics specified by \code{plot_values}. Each row represents a data point
in the combination data. The data point specified by \code{highlight_row}
will be highlighted in different color.
}
\examples{
data("NCATS_screening_data")
data <- ReshapeData(NCATS_screening_data)
data <- CalculateSynergy(data, method = c("HSA"))
p <- PlotMultiDrugBar(data, 
  plot_block = 1,
  plot_value = c("response", "HSA_ref", "HSA_synergy"),
  highlight_row = c(0, 0, 0),
  sort_by = "HSA_synergy"
)
p
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
