% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_wrapper.R
\name{PlotDoseResponse}
\alias{PlotDoseResponse}
\title{Visualize the Drug Combination Dose-response Data}
\usage{
PlotDoseResponse(
  data,
  block_ids = c(1),
  drugs = c(1, 2),
  adjusted = TRUE,
  statistic = NULL,
  summary_statistic = "mean",
  high_value_color = "#FF0000",
  low_value_color = "#00FF00",
  point_color = "#C24B40",
  curve_color = "black",
  curve_ylim = NULL,
  curve_grid = TRUE,
  text_size_scale = 1,
  heatmap_text_label_size_scale = 1,
  heatmap_text_label_color = "#000000",
  heatmap_color_range = NULL,
  curve_plot_title = NULL,
  heatmap_plot_title = NULL,
  Emin = NA,
  Emax = NA,
  save_file = FALSE,
  file_type = "pdf",
  file_name = NULL,
  width = 12,
  height = 6
)
}
\arguments{
\item{data}{A list object generated by function \code{\link{ReshapeData}}.}

\item{block_ids}{A vector of characters/integers or NULL. It contains the
block IDs for the blocks to visualize. By default, it is NULL so that the
visualization of all the drug combinations in input \code{data}.}

\item{drugs}{A vector of characters or integers with length of 2. It contains
the index for two drugs to plot. For example, \code{c(1, 2)} indicates to
plot "drug1" and "drug2" in the input \code{data}.}

\item{adjusted}{A logical value. If it is \code{FALSE}, original response
matrix will be plotted. If it is \code{TRUE}, adjusted response matrix will
be plotted.}

\item{statistic}{A character or NULL. It indicates the statistics printed
in the plot while there are replicates in input data. Available values are:
\itemize{
  \item \strong{sem} Standard error of mean;
  \item \strong{ci} 95% confidence interval.
}
If it is \code{NULL}, no statistics will be printed.}

\item{summary_statistic}{A vector of characters or NULL. It indicates the
summary statistics printed in heatmap for all the \code{plot_value} in
whole combination matrix. Available values are:
\itemize{
  \item \strong{mean} Median value for all the responses or synergy
  scores in the matrix and the p-value if it is valid;
  \item \strong{median} Median value for all the responses or synergy
  scores in the matrix;
  \item \strong{quantile_90} 90% quantile. User could change the number to
  print different sample quantile. For example quantile_50 equal to median. 
}
If it is \code{NULL}, no statistics will be printed.}

\item{high_value_color}{An R color value. It indicates the color for the
high values.}

\item{low_value_color}{An R color value. It indicates the color for low
values.}

\item{point_color}{An R color value. It indicates the color for points in
dose response curve plots.}

\item{curve_color}{An R color value. It indicates the color for curves in 
dose response curve plots.}

\item{curve_ylim}{A vector of two numeric values or \code{NULL}. It is used
to set the y limits (y1, y2) of the dose-response curve plot. Note that
y1 > y2 is allowed and leads to a ‘reversed axis’. With the default value,
\code{NULL}, the function will automatically set the y axis.}

\item{curve_grid}{A logical value. It indicates whether to add grids on the
dose-response curve pot.}

\item{text_size_scale}{A numeric value. It is used to control the size
of text in the plot. All the text size will multiply by this scale factor.}

\item{heatmap_text_label_size_scale}{A numeric value. It is used to control
the size of text labels in the heatmap plot. It only works while 
\code{plot_type = "heatmap"}.}

\item{heatmap_text_label_color}{NULL or an R color value. It is used to
control the color of text labels in the heatmap plot. If it is \code{NULL},
text label will not be shown.It only works while
\code{plot_type = "heatmap"}.}

\item{heatmap_color_range}{A vector of two numeric values. They specify the
range of the color bar in heatmap plot. The first item (lower bounder) must
be less than the second one (upper bounder). The plotted values larger than
defined upper bounder will be filled in color \code{high_value_color}. The
plotted values less than defined lower bounder will be filled in color
\code{low_value_color}. If the defined range includes 0, value 0 will be
filled in color "white". By default, it is set as \code{NULL} which
means the function will automatically set the color range according to
the plotted values.}

\item{curve_plot_title}{A character value to indicate the plot title for
the dose-response curve.}

\item{heatmap_plot_title}{A character value to indicate the plot title for
the heatmap.}

\item{Emin}{A numeric or \code{NA}. the minimal effect of the drug used in
the 4-parameter log-logistic function to fit the dose-response curve. If
it is not NA, it is fixed the value assigned by the user. Default setting
is \code{NA}.}

\item{Emax}{A numeric or \code{NA}. the maximal effect of the drug used in
the 4-parameter log-logistic function to fit the dose-response curve. If
it is not NA, it is fixed the value assigned by the user. Default setting
is \code{NA}.}

\item{save_file}{A parameter to specify if the visualization results are
saved as pdf files in current working directory or not. If it is FALSE,
the results are returned as a list of the plots. It is FALSE by default.}

\item{file_type}{A character. It indicates the format of files you want to
save as. Default is "pdf". Available values are "jpeg", "bmp", "png",
"tiff", "pdf", "svg".}

\item{file_name}{A character vector. It indicates the file names, if
user chose to save the plot to local directory.If it is not defined by
user, a default name will be assigned.}

\item{width}{a numeric value. It indicates the width of saved file.}

\item{height}{a numeric value. It indicates the height of saved file.}
}
\value{
A list of plot objects recorded by \link[grDevices]{recordPlot}. The 
  plot will be saved into a local file if \code{save_file = TRUE}. If 
  \code{save_file = FALSE}, the plot will be printed in default graphic
  device.
}
\description{
A function to visualize the drug combination dose-response data
}
\examples{
\dontrun{
data("mathews_screening_data")
data <- ReshapeData(mathews_screening_data)
plots <- PlotDoseResponse(data)
}
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
