% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_sensitivity_score.R
\name{ImputeIC50}
\alias{ImputeIC50}
\title{Impute Missing Value at IC50 Concentration of Drug}
\usage{
ImputeIC50(response.mat, col.ic50, row.ic50)
}
\arguments{
\item{response.mat}{A matrix. It contains response value of a block of drug
combination.}

\item{col.ic50}{A numeric value. The IC50 value of drug added to columns.}

\item{row.ic50}{A numeric value. The IC50 value of drug added to rows.}
}
\value{
A data frame contains all response value at the IC50 concentration
  of certein drug. It could be directly passed to function
  \code{CalculateRI} for scoring.
}
\description{
\code{ImputeIC50} uses the particular experiment's values to predict the
missing values at the desired IC50 concentration of the drug.
This function is only called when trying to fix a drug at its selected IC50
concentration where the response values have not been tested in experiment.
}
\details{
\code{ImputeIC50} fits dose-response models (with \code{\link[drc]{drm}}
function) by fixing the concentrations of the
\strong{other} drug successively, and uses each fit to predict the missing
value at the combination (missing IC50, fixed conc).
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
