% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_synergy_score.R
\name{CalculateSynergy}
\alias{CalculateSynergy}
\title{Calculate the Synergy Scores for Drug Combinations}
\usage{
CalculateSynergy(
  data,
  method = c("ZIP", "HSA", "Bliss", "Loewe"),
  Emin = NA,
  Emax = NA,
  adjusted = TRUE,
  correct_baseline = "non",
  iteration = 10,
  seed = 123
)
}
\arguments{
\item{data}{A list object generated by function \code{\link{ReshapeData}}.}

\item{method}{A vector of characters. It is used to specify the reference
models used to calculate the synergy scores. Choices are "ZIP", "Bliss",
"HSA" and "Loewe". Default setting is to calculate all the available
models.}

\item{Emin}{The expected minimum response value in the 4 parameter 
log-logistic model. It is used while calling \code{\link{ZIP}} and
\code{\link{Loewe}}.}

\item{Emax}{The expected maximum response value in the 4 parameter 
log-logistic model. It is used while calling \code{\link{ZIP}} and
\code{\link{Loewe}}.}

\item{adjusted}{A logical value. If it is \code{TRUE}, the 'response' column
in the table 'data$response' will be used to calculate synergy scores.
If it is \code{FALSE}, the raw data 'response_origin' column will be used
to calculate synergy scores.}

\item{correct_baseline}{A character value. It indicates the method used for
baseline correction. Available values are:
\itemize{
  \item \strong{non} No baseline correction.
  \item \strong{part} Adjust only the negative values in the matrix.
  \item \strong{all} Adjust all values in the matrix.
}}

\item{iteration}{An integer value. It indicates the number of iterations for
bootstrap on data with replicates.}

\item{seed}{An integer or NULL. It is used to set the random seed in synergy
scores calculation on data with replicates.}
}
\value{
This function will add 1 or 2 elements into inputted \code{data}
  list:
  \itemize{
    \item \strong{scores} A data frame. It contains synergy scores, 
    reference effects and fitted response values (only for "ZIP" model) 
    calculated by selected \code{method}. If there are replicates in the
    block, the mean values across all iterations for all the metrics
    mentioned above will be output.
    \item \strong{scores_statistics} A data frame. It will be output if
    there is block have replicated response values. It contains the
    the statistics (including mean, standard deviation, standard error of 
    mean and 95% confidence interval) for synergy scores, reference effects
    and fitted response values (only for "ZIP" model) across results from
    iterations.
 }
 This function also add mean of synergy scores across whole combination
 matrix to the \code{data$drug_pair} table.
}
\description{
\code{CalculateSynergy} is the main function for calculating synergy scores
  based on model(ZIP, Bliss, Loewe, and HSA) from one dose-response matrix.
}
\examples{
data("mathews_screening_data")
data <- ReshapeData(mathews_screening_data)
scores <- CalculateSynergy(data)
}
\author{
\itemize{
    \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
    \item Jing Tang \email{jing.tang@helsinki.fi}
 }
}
