% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_foci.R
\name{get_coincident_foci}
\alias{get_coincident_foci}
\title{get_coincident_foci}
\usage{
get_coincident_foci(
  offset_px,
  offset_factor,
  brush_size,
  brush_sigma,
  annotation,
  watershed_stop,
  watershed_radius,
  watershed_tol,
  crowded_foci,
  artificial_amp_factor,
  strand_amp,
  disc_size,
  disc_size_foci,
  img_file,
  cell_count,
  img_orig,
  img_orig_foci,
  stage,
  WT_str,
  KO_str,
  WT_out,
  KO_out,
  C1_search,
  discrepant_category,
  C1,
  C2,
  df_cells,
  C_weigh_foci_number
)
}
\arguments{
\item{offset_px, }{Pixel value offset used in thresholding of synaptonemal complex channel}

\item{offset_factor, }{Pixel value offset used in thresholding of foci channel}

\item{brush_size, }{size of brush to smooth the foci channel. Should be small
to avoid erasing foci.}

\item{brush_sigma, }{sigma for Gaussian smooth of foci channel. Should be
small to avoid erasing foci.}

\item{annotation, }{Choice to output pipeline choices (recommended to knit)}

\item{watershed_stop}{Stop default watershed method with "on"}

\item{watershed_radius}{Radius (ext variable) in watershed method used
in foci channel. Defaults to 1 (small)}

\item{watershed_tol}{Intensity tolerance for watershed method. Defaults to 0.05.}

\item{crowded_foci}{TRUE or FALSE, defaults to FALSE. Set to TRUE if you
have foci > 100 or so.}

\item{artificial_amp_factor}{Amplification of foci channel, for annotation only.}

\item{strand_amp}{multiplication of strand channel to make masks}

\item{disc_size}{size of disc for local background calculation in synaptonemal complex channel}

\item{disc_size_foci}{size of disc for local background calculation in foci channel}

\item{img_file}{cell's file name}

\item{cell_count}{unique cell counter}

\item{img_orig}{original strand crop}

\item{img_orig_foci}{cropped foci channel}

\item{stage, }{meiosis stage of interest. Currently count_foci determines
this with thresholding/ object properties in the synaptonemal complex channel
by previosly calling the get_pachytene function.
Note that if using this option, the count_foci function requires that the
input directory contains a folder called “pachytene” with the crops in it.}

\item{WT_str}{string in filename corresponding to wildtype genotype.
Defaults to ++.}

\item{KO_str}{string in filename corresponding to knockout genotype.
Defaults to --.}

\item{WT_out}{string in output csv in genotype column, for knockout.
Defaults to +/+.}

\item{KO_out}{string in output csv in genotype column, for knockout.
Defaults to -/-.}

\item{C1_search}{TRUE or FALSE whether the image is still being modified
until it meets the crispness criteria}

\item{discrepant_category}{estimated number of foci that are NOT on a strand.}

\item{C1}{Default crispness criteria = sd(foci_area)/(mean(foci_area)+1)}

\item{C2}{Alternative crisp criteria.}

\item{df_cells}{current data frame}

\item{C_weigh_foci_number}{choose crispness criteria- defaults to TRUE to use
C1 (weighing with number). Otherwise set to FALSE to use C2}
}
\value{
data frame with new row with most recent foci per cell appended
}
\description{
calculates the statistic to compare to crisp_criteria, which determines
whether the foci count will be reliable
}
