% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switchde.R
\name{fit_zi_model}
\alias{fit_zi_model}
\title{Fit a zero-inflated model for a single gene}
\usage{
fit_zi_model(y, pst, maxiter = 10000, log_lik_tol = 0.001,
  verbose = FALSE)
}
\arguments{
\item{y}{Vector of gene expression values}

\item{pst}{Pseudotime vector, of same length as y}

\item{maxiter}{Maximum number of iterations for EM algorithm if zero inflation enabled. Default 100}

\item{log_lik_tol}{If the change in the log-likelihood falls below this for zero inflated EM
the algorithm is assumed to have converged}

\item{verbose}{Print convergence update for EM algorithm}
}
\value{
A vector with 6 entries: maximum likelihood estimates for \eqn{\mu_0}, \eqn{k}
\eqn{t0}, \eqn{\lambda}, \eqn{\sigma^2} and a p-value
}
\description{
Fits a zero-inflated sigmoidal model for a single gene vector, returning
MLE model parameters and p-value.
}
\examples{
data(synth_gex)
data(ex_pseudotime)
y <- synth_gex[1, ]
fit <- fit_zi_model(y, ex_pseudotime)
}
