% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/iterator_class.R
\name{run}
\alias{run}
\alias{evaluate}
\alias{iterator}
\alias{run,iterator,DatasetExperiment,metric-method}
\alias{evaluate,iterator,metric-method}
\alias{models,iterator-method}
\alias{models<-,iterator,model_OR_iterator-method}
\alias{result_name<-,iterator,character-method}
\alias{result,iterator-method}
\alias{result_name,iterator-method}
\alias{*,iterator,model_OR_iterator-method}
\alias{[,iterator,ANY,ANY,ANY-method}
\alias{[<-,iterator,ANY,ANY,ANY-method}
\title{Run iterator}
\usage{
run(I, D, MET)

evaluate(I, MET)

iterator(...)

\S4method{run}{iterator,DatasetExperiment,metric}(I, D, MET = NULL)

\S4method{evaluate}{iterator,metric}(I, MET)

\S4method{models}{iterator}(ML)

\S4method{models}{iterator,model_OR_iterator}(ML) <- value

\S4method{result_name}{iterator,character}(I) <- value

\S4method{result}{iterator}(M)

\S4method{result_name}{iterator}(M)

\S4method{*}{iterator,model_OR_iterator}(e1, e2)

\S4method{[}{iterator,ANY,ANY,ANY}(x, i)

\S4method{[}{iterator,ANY,ANY,ANY}(x, i) <- value
}
\arguments{
\item{I}{an iterator object}

\item{D}{a dataset object}

\item{MET}{a metric object}

\item{...}{named slots and their values.}

\item{ML}{a model sequence object}

\item{value}{value}

\item{M}{a model object}

\item{e1}{an iterator object}

\item{e2}{an iterator or a model object}

\item{x}{a sequence object}

\item{i}{index into sequence}
}
\value{
Modified iterator object

Modified iterator object

the modified model object

model at the given index in the sequence

iterator with the model at index i replaced
}
\description{
Runs an iterator, applying the chosen model multiple times.

Evaluates an iterator by e.g. averaging over all iterations. May be
deprecated in a future release as \code{evaluate} is applied by \code{run}
anyway.

A class for iterative approaches that involve the training/prediction of a
model multiple times. Not intended to be called directly, this class should
be inherited to provide functionality for method-specific classes.
}
\details{
Running an iterator will apply the iterator a number of times to a dataset_
For example, in cross-validation the same model is applied multiple times to
the same data, splitting it into training and test sets. The input metric
object can be calculated and collected for each iteration as an output_
}
\examples{
D = iris_DatasetExperiment() # get some data
MET = metric()  # use a metric
I = example_iterator() # initialise iterator
models(I) = example_model() # set the model
I = run(I,D,MET) # run
D = iris_DatasetExperiment() # get some data
MET = metric()  # use a metric
I = example_iterator() # initialise iterator
models(I) = example_model() # set the model
I = run(I,D,MET) # run
I = evaluate(I,MET) # evaluate
I = iterator()
I = iterator() * model()
D = DatasetExperiment()
MET = metric()
I = iterator() * model()
I = run(I,D,MET)

I = iterator()
result_name(I) = 'example'
MS = model() + model()
I = iterator() * MS
I[2] # returns the second model() object

MS = model() + model()
I = iterator() * MS
I[2] = model() # sets the second model to model()

}
