% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/struct_class.R,
%   R/model_list_class.R, R/iterator_class.R
\name{as.code}
\alias{as.code}
\alias{as.code,struct_class-method}
\alias{as.code,model_seq-method}
\alias{as.code,iterator-method}
\title{Convert to code}
\usage{
as.code(M, start = "M = ", mode = "compact", quiet = FALSE)

\S4method{as.code}{struct_class}(M, start = "M = ", mode = "compact", quiet = FALSE)

\S4method{as.code}{model_seq}(M, start = "M = ", mode = "compact", quiet = FALSE)

\S4method{as.code}{iterator}(M, start = "M = ", mode = "compact", quiet = FALSE)
}
\arguments{
\item{M}{a struct model, model_seq or iterator object}

\item{start}{text prepended to the code. Default is "M = "}

\item{mode}{"compact" will use the least amount of lines, "expanded" will
put each object and input on a new line. "neat" will produce an output
somewhere between "compact" and "expanded".}

\item{quiet}{TRUE or FALSE to print code to console}
}
\value{
A string of code to reproduce the input object.

a string of code to reproduce the model

a string of code to reproduce the model sequence

a string of code to reproduce the iterator
}
\description{
Prints a block of code that can be used to replicate the input object.
}
\examples{
M = example_model(value_1 = 10)
as.code(M)
M = example_model()
as.code(M)
M = example_model()
as.code(M)
M = example_model()
as.code(M)
}
