% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcox_test_class.R
\name{wilcox_test}
\alias{wilcox_test}
\title{wilcoxon signed rank test}
\usage{
wilcox_test(
  alpha = 0.05,
  mtc = "fdr",
  factor_names,
  paired = FALSE,
  paired_factor = character(0),
  conf_level = 0.95,
  ...
)
}
\arguments{
\item{alpha}{(numeric) The p-value cutoff for determining significance. The default is \code{0.05}.\cr}

\item{mtc}{(character) Multiple test correction method. Allowed values are limited to the following: \itemize{ \item{\code{"bonferroni"}: Bonferroni correction in which the p-values are multiplied by the number of comparisons.}\item{\code{"fdr"}: Benjamini and Hochberg False Discovery Rate correction.}\item{\code{"none"}: No correction.}} The default is \code{"fdr"}.}

\item{factor_names}{(character) The name of a sample-meta column to use.}

\item{paired}{(logical) Apply a paired test. The default is \code{FALSE}.\cr}

\item{paired_factor}{(character) The factor name containing sample ids for paired data. The default is \code{character(0)}.}

\item{conf_level}{(numeric) The confidence level of the interval. The default is \code{0.95}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{wilcox_test} object with the following \code{output} slots:
\tabular{ll}{
\code{statistic} \tab          (data.frame) The value of the calculated statistic which is converted to a p-value. \cr
\code{p_value} \tab          (data.frame) The probability of observing the calculated t-statistic. \cr
\code{dof} \tab          (numeric) The number of degrees of freedom used to calculate the test statistic. \cr
\code{significant} \tab          (data.frame) TRUE if the calculated p-value is less than the supplied threhold (alpha). \cr
\code{conf_int} \tab          (data.frame) Confidence interval for t statistic. \cr
\code{estimates} \tab          (data.frame) The group estimates used when computing the statistic. \cr
}

struct object
}
\description{
A Mann-Whitney-Wilcoxon signed rank test compares ,the ranks of values in two groups. It is the non-parametric equivalent of a t-test. Multiple test corrected p-values are computed as indicators of significance for each variable/feature.
}
\section{Inheritance}{

A \code{wilcox_test} object inherits the following \code{struct} classes: \cr\cr
\verb{[wilcox_test]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = wilcox_test(
      alpha = 0.05,
      mtc = "fdr",
      factor_names = "V1",
      paired = FALSE,
      paired_factor = character(0),
      conf_level = 0.95)

M = wilcox_test(factor_name='Class')

}
