% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_centre_class.R
\name{mean_centre}
\alias{mean_centre}
\title{Mean centre}
\usage{
mean_centre(mode = "data", ...)
}
\arguments{
\item{mode}{(character) Mode of action. Allowed values are limited to the following: \itemize{ \item{\code{"data"}: Centring is applied to the data block.}\item{\code{"sample_meta"}: Centring is applied to the sample_meta block.}\item{\code{"both"}: Centring is applied to both the data and the sample_meta blocks.}} The default is \code{"data"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{mean_centre} object with the following \code{output} slots:
\tabular{ll}{
\code{centred} \tab          (DatasetExperiment)  \cr
\code{mean_data} \tab          (numeric)  \cr
\code{mean_sample_meta} \tab          (numeric)  \cr
}
}
\description{
The mean sample is subtracted from all samples in the data matrix. The features in the centred matrix all have zero mean.
}
\section{Inheritance}{

A \code{mean_centre} object inherits the following \code{struct} classes: \cr\cr
\verb{[mean_centre]} >> \verb{[preprocess]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = mean_centre(
      mode = "data")

M = mean_centre()
}
