% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classical_lsq_class.R
\name{classical_lsq}
\alias{classical_lsq}
\title{Univariate Classical Least Squares Regression}
\usage{
classical_lsq(alpha = 0.05, mtc = "fdr", factor_names, intercept = TRUE, ...)
}
\arguments{
\item{alpha}{(numeric) The p-value cutoff for determining significance. The default is \code{0.05}.\cr}

\item{mtc}{(character) Multiple test correction method. Allowed values are limited to the following: \itemize{ \item{\code{"bonferroni"}: Bonferroni correction in which the p-values are multiplied by the number of comparisons.}\item{\code{"fdr"}: Benjamini and Hochberg False Discovery Rate correction.}\item{\code{"none"}: No correction.}} The default is \code{"fdr"}.}

\item{factor_names}{(character, list) The column names to regress against. If a character vector then the same list is used ofr all features. If a list of character vectors is provided it is assumed there is a different set of columns for each feature.}

\item{intercept}{(logical) Model intercept. Allowed values are limited to the following: \itemize{ \item{\code{"TRUE"}: An intercept term is included in the model.}\item{\code{"FALSE"}: An intercept term is not included in the model.}} The default is \code{TRUE}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{classical_lsq} object with the following \code{output} slots:
\tabular{ll}{
\code{coefficients} \tab          (data.frame) The regression coefficients for each term in the model. \cr
\code{p_value} \tab          (data.frame) The probability of observing the calculated statistic if the null hypothesis is true. \cr
\code{significant} \tab          (data.frame) True/False indicating whether the p-value computed for each variable is less than the threshold. \cr
\code{r_squared} \tab          (data.frame) The value of R Squared for the fitted model. \cr
\code{adj_r_squared} \tab          (data.frame) The value ofAdjusted  R Squared for the fitted model. \cr
}
}
\description{
In univariate classical least squares regression a line is fitted between each feature/variable and a response variable. The fitted line minimises the sum of squared differences between the true response and the predicted response. The coefficients (offset, gradient) of the fit can be tested for significance.
}
\section{Inheritance}{

A \code{classical_lsq} object inherits the following \code{struct} classes: \cr\cr
\verb{[classical_lsq]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = classical_lsq(
      alpha = 0.05,
      mtc = "fdr",
      factor_names = "V1",
      intercept = FALSE)

D = iris_DatasetExperiment()
M = classical_lsq(factor_names = 'Species')
M = model_apply(M,D)
}
