% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statTarget_rforest.R
\name{rForest}
\alias{rForest}
\title{Random Forest classfication in statTarget}
\usage{
rForest(file,ntree = 100,times = 100, gDist = TRUE,
seed = 123,...)
}
\arguments{
\item{file}{An data frame or 'Stat File' from statTarget software.}

\item{ntree}{Number of trees to grow. This should not be set to too small a 
number, to ensure that every input row gets predicted at least a few times.}

\item{times}{The number of permutations for 
permutation-based variable importance measures.}

\item{gDist}{If gDist is TRUE the null importance distributions are 
approximated with Gaussian distributions else with empirical cumulative 
distributions.}

\item{seed}{For the same set of random variables and reproducible results.}

\item{...}{A generic function in randomForest package}
}
\value{
Objects  Two objects from statTarget_rForest (1. randomForest,rfModel; 
2. PIMPresult, pimpModel)

VarImp  The original Gini importance

PerVarImp  A matrix, where the permuted VarImp measures for the
predictor variable.

p-value  The probability of observing the original VarImp or a larger
value, given the fitted null importance distribution.

p.ks.test The p-values of the Kolmogorov-Smirnov Tests for 
each row PerVarImp.
}
\description{
rForest provides the Breiman's random 
forest algorithm for classification and permutation-based variable 
importance measures (PIMP-algorithm).
}
\examples{
datpath <- system.file('extdata',package = 'statTarget')
statFile <- paste(datpath,'data_example_long.csv', sep='/')
getFile <- read.csv(statFile,header=TRUE)
rFtest <- rForest(getFile,ntree = 10,times = 5)
}
\references{
Altmann A.,Tolosi L.,Sander O. and Lengauer T. (2010) Permutation importance: 
a corrected feature importance measure, Bioinformatics 26 (10), 1340-1347.

Ender Celik. (2015) vita: Variable Importance Testing Approaches. R package 
version 1.0.0 https://CRAN.R-project.org/package=vita
}
\author{
Hemi Luan, hemi.luan@gmail.com
}
