% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomForest_ptest.R
\name{pvimPlot}
\alias{pvimPlot}
\title{Gini importance and permutation-based variable 
importance measures plots}
\usage{
pvimPlot(rForest,pimpModel,nvarRF = 6,border= NA,
space = 0.3,...)
}
\arguments{
\item{rForest}{an object of class randomForest that contains the proximity 
component from statTarget rForest function.}

\item{pimpModel}{an object of permutation-based variable Gini importance 
measures (PIMP-algorithm) from statTarget rForest function.}

\item{nvarRF}{The number of variables in importance plot of randomForest.}

\item{border}{The color to be used for the border of the bars. 
Use border = NA to omit borders. see also barplot.}

\item{space}{The amount of space (as a fraction of the average bar width) 
left before each bar. May be given as a single number or one number per bar.
see also barplot}

\item{...}{A generic barplot function from graphics package.}
}
\value{
The output of the name of selected variable importance.
}
\description{
Create plots for Gini importance and permutation-based variable 
Gini importance measures.
}
\examples{
datpath <- system.file('extdata',package = 'statTarget')
statFile <- paste(datpath,'data_example_long.csv', sep='/')
getFile <- read.csv(statFile,header=TRUE)
rFtest <- rForest(getFile,ntree = 10,times = 5)
pvimPlot(rFtest$randomForest,rFtest$pimpTest)
}
\author{
Hemi Luan, hemi.luan@gmail.com
}
