% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{srnadiffExample}
\alias{srnadiffExample}
\title{Example constructor}
\usage{
srnadiffExample()
}
\value{
An \code{srnadiffExp} object called '\code{srnaExp}'.
}
\description{
This function provides an example of a \code{srnadiffExp} object which
contains mapped reads of small RNAs extracted from SLK cells infected with
latent KSHV, compared to uninfected SLK cells.
}
\details{
Raw data have been downloaded from the GEO data set GSE62830, provided in
Viollet et \emph{al}. (2015). Adapters were removed with
fastx_clipper and mapped with bowtie2 (Salzberg and Langmead, 2012) on the
human genome version GRCh38.

This example is restricted to a small locus on chr14.
It uses the whole genome annotation (with coding genes, etc.) and extracts
miRNAs.
}
\examples{
## The 'srnadiffExp' object in this example was constructed by:

\dontrun{

basedir             <- system.file("extdata", package="srnadiff", mustWork = TRUE)
sampleInfo          <- read.csv(file.path(basedir, "dataInfo.csv"))
gtfFile             <- file.path(basedir, "Homo_sapiens.GRCh38.76.gtf.gz")
annotReg            <- readAnnotation(gtfFile, feature="gene", source="miRNA")
bamFiles            <- file.path(basedir, sampleInfo$FileName)
srnaExp             <- srnadiffExp(bamFiles, sampleInfo, annotReg)
parameters(srnaExp) <- srnadiffDefaultParameters
save(srnaExp, file = file.path(basedir, "srnadiffExample.rda"))
}

srnaExp <- srnadiffExample()
srnaExp

}
\references{
Viollet, Coralie, David A. Davis, Martin Reczko, Joseph M. Ziegelbauer,
Francesco Pezzella, Jiannis Ragoussis, and Robert Yarchoan (2015).
"Next-Generation Sequencing Analysis Reveals Differential Expression
Profiles of MiRNA-mRNA Target Pairs in KSHV-Infected Cells."
\emph{PLOS ONE}, 10:1–23.

Salzberg, Steven, and Ben Langmead (2012). "Fast gapped-read alignment
with Bowtie 2." \emph{Nature Methods}, 9:357–59.
}
