\name{TCsimData}
\alias{TCsimData}
\docType{data}
\title{
Simulated time-course gene expression data set
}
\description{
Simulated data set of gene expression temporal profiles of 2000 genes. Data contain expression values in 8 time points after applying 2 differrent types of perturbation/treatment (\code{"T1"} and \code{"T2"}). 
}
\usage{data(TCsimData)}

\format{
An object of class \code{ExpressionSet} with 2000 observations per time point and perturbation/treatment. Phenotypic data of the object (\code{pData(TCsimData)}) contain 4 columns with the following variables:

  \describe{
    \item{\code{SampleName}}{names of the samples}
    \item{\code{Time}}{time points when samples were collected}
    \item{\code{Treatment}}{types of treatment}
    \item{\code{Replicate}}{names of replicates}
  }
}
\details{
Simulation experiments were conducted using GeneNetWeaver (GNW), an open-source simulator for the DREAM challenges. The \emph{in silico} expression data were simulated based on the network structure of a 2000-gene sub-network from the Reactome functional interaction network. The sub-network was converted to a dynamical network model without autoregulatory interactions (self-loops). The data were simulated based on the \emph{"ODEs"} model. Two types of time-series experiments were chosen: \emph{"Time Series as in DREAM4"} and \emph{"Multifactorial"}. Gene expression data were simulated for 48 time points after perturbations. For more details see GNW User Manual. 

The names of \emph{"Time Series as in DREAM4"} and \emph{"Multifactorial"} simulation experiments were changed to \code{"T1"} and \code{"T2"}, respectively. From the generated data sets, eight time points are provided (1, 4, 8, 16, 24, 32, 40 and 48). The numbers correspond to the same time units after perturbation (e.g. minutes, hours, days, ect.). Replicates for both time-course experiments were generated by the addition of the normally distributed random errors with a standard deviation of 0.05 to the expression values for each time point. Subsequently, the entire dataset was normalized between 0 and 1.
}

\value{An object of class \code{ExpressionSet}.}
\references{
Marbach, D., Schaffter, T., Mattiussi, C., and Floreano, D. (2009). Generating realistic in silico gene networks for performance assessment of reverse engineering methods.
\emph{Journal of Computational Biology} 2(16), 229-239.

Schaffter, T., Marbach, D., and Roulet G. (2010). GNW User Manual.
\url{http://gnw.sourceforge.net}

Reactome project. Reactome Functional Interaction Network. Retrieved September 25, 2015 from \url{http://www.reactome.org/}

}
\examples{
data(TCsimData)
pData(TCsimData)
head(exprs(TCsimData),3)
}
\keyword{datasets}
