% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{diffSCEs}
\alias{diffSCEs}
\title{Diff SingleCellExperiment objects}
\usage{
diffSCEs(
  sces,
  ref,
  point.size = 0.1,
  point.alpha = 0.1,
  fits = TRUE,
  colours = NULL
)
}
\arguments{
\item{sces}{named list of SingleCellExperiment objects to combine and
compare.}

\item{ref}{string giving the name of the SingleCellExperiment to use as the
reference}

\item{point.size}{size of points in scatter plots.}

\item{point.alpha}{opacity of points in scatter plots.}

\item{fits}{whether to include fits in scatter plots.}

\item{colours}{vector of colours to use for each dataset.}
}
\value{
List containing the combined datasets and plots.
}
\description{
Combine the data from several SingleCellExperiment objects and produce some
basic plots comparing them to a reference.
}
\details{
This function aims to look at the differences between a reference
SingleCellExperiment and one or more others. It requires each
SingleCellExperiment to have the same dimensions. Properties are compared by
ranks, for example when comparing the means the values are ordered and the
differences between the reference and another dataset plotted. A series of
Q-Q plots are also returned.

The returned list has five items:

\describe{
    \item{\code{Reference}}{The SingleCellExperiment used as the reference.}
    \item{\code{RowData}}{Combined feature data from the provided
    SingleCellExperiments.}
    \item{\code{ColData}}{Combined column data from the provided
    SingleCellExperiments.}
    \item{\code{Plots}}{Difference plots
        \describe{
            \item{\code{Means}}{Boxplot of mean differences.}
            \item{\code{Variances}}{Boxplot of variance differences.}
            \item{\code{MeanVar}}{Scatter plot showing the difference from
            the reference variance across expression ranks.}
            \item{\code{LibraeySizes}}{Boxplot of the library size
            differences.}
            \item{\code{ZerosGene}}{Boxplot of the differences in the
            percentage of each gene that is zero.}
            \item{\code{ZerosCell}}{Boxplot of the differences in the
            percentage of each cell that is zero.}
            \item{\code{MeanZeros}}{Scatter plot showing the difference from
            the reference percentage of zeros across expression ranks.}
    }
  }
  \item{\code{QQPlots}}{Quantile-Quantile plots
      \describe{
          \item{\code{Means}}{Q-Q plot of the means.}
          \item{\code{Variances}}{Q-Q plot of the variances.}
          \item{\code{LibrarySizes}}{Q-Q plot of the library sizes.}
          \item{\code{ZerosGene}}{Q-Q plot of the percentage of zeros per
          gene.}
          \item{\code{ZerosCell}}{Q-Q plot of the percentage of zeros per
          cell.}
      }
  }
}

The plots returned by this function are created using
\code{\link[ggplot2]{ggplot}} and are only a sample of the kind of plots you
might like to consider. The data used to create these plots is also returned
and should be in the correct format to allow you to create further plots
using \code{\link[ggplot2]{ggplot}}.
}
\examples{
sim1 <- splatSimulate(nGenes = 1000, batchCells = 20)
sim2 <- simpleSimulate(nGenes = 1000, nCells = 20)
difference <- diffSCEs(list(Splat = sim1, Simple = sim2), ref = "Simple")
names(difference)
names(difference$Plots)
}
