% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{KersplatParams}
\alias{KersplatParams}
\alias{KersplatParams-class}
\title{The KersplatParams class}
\description{
S4 class that holds parameters for the Kersplat simulation.
}
\section{Parameters}{


The Kersplat simulation uses the following parameters:

\describe{
    \item{\code{nGenes}}{The number of genes to simulate.}
    \item{\code{nCells}}{The number of cells to simulate.}
    \item{\code{[seed]}}{Seed to use for generating random numbers.}
    \item{\emph{Mean parameters}}{
        \describe{
            \item{\code{mean.shape}}{Shape parameter for the mean gamma
            distribution.}
            \item{\code{mean.rate}}{Rate parameter for the mean gamma
            distribution.}
            \item{\code{mean.outProb}}{Probability that a gene is an
            expression outlier.}
            \item{\code{mean.outFacLoc}}{Location (meanlog) parameter for
            the expression outlier factor log-normal distribution.}
            \item{\code{mean.outFacScale}}{Scale (sdlog) parameter for the
            expression outlier factor log-normal distribution.}
            \item{\code{mean.dens}}{\code{\link{density}} object describing
            the log gene mean density.}
            \item{\code{[mean.method]}}{Method to use for simulating gene
            means. Either "fit" to sample from a gamma distribution (with
            expression outliers) or "density" to sample from the provided
            density object.}
            \item{\code{[mean.values]}}{Vector of means for each gene.}
        }
    }
    \item{\emph{Biological Coefficient of Variation parameters}}{
        \describe{
            \item{\code{bcv.common}}{Underlying common dispersion across all
            genes.}
            \item{\code{[bcv.df]}}{Degrees of Freedom for the BCV inverse
            chi-squared distribution.}
        }
    }
    \item{\emph{Network parameters}}{
        \describe{
            \item{\code{[network.graph]}}{Graph containing the gene network.}
            \item{\code{[network.nRegs]}}{Number of regulators in the
            network.}
        }
    }
    \item{\emph{Paths parameters}}{
        \describe{
            \item{\code{[paths.programs]}}{Number of expression programs.}
            \item{\code{[paths.design]}}{data.frame describing path
            structure. See \code{\link{kersplatSimPaths}} for details.}
        }
    }
    \item{\emph{Library size parameters}}{
        \describe{
            \item{\code{lib.loc}}{Location (meanlog) parameter for the
            library size log-normal distribution, or mean parameter if a
            normal distribution is used.}
            \item{\code{lib.scale}}{Scale (sdlog) parameter for the library
            size log-normal distribution, or sd parameter if a normal
            distribution is used.}
            \item{\code{lib.dens}}{\code{\link{density}} object describing
            the library size density.}
            \item{\code{[lib.method]}}{Method to use for simulating library
            sizes. Either "fit" to sample from a log-normal distribution or
            "density" to sample from the provided density object.}
        }
    }
    \item{\emph{Design parameters}}{
        \describe{
            \item{\code{[cells.design]}}{data.frame describing cell
            structure. See \code{\link{kersplatSimCellMeans}} for details.}
        }
    }
    \item{\emph{Doublet parameters}}{
        \describe{
            \item{\code{[doublet.prop]}}{Proportion of cells that are
            doublets.}
        }
    }
    \item{\emph{Ambient parameters}}{
        \describe{
            \item{\code{[ambient.scale]}}{Scaling factor for the library
            size log-normal distribution when generating ambient library
            sizes.}
            \item{\code{[ambient.nEmpty]}}{Number of empty cells to
            simulate.}
        }
    }
}

The parameters not shown in brackets can be estimated from real data using
\code{\link{kersplatEstimate}}. For details of the Kersplat simulation
see \code{\link{kersplatSimulate}}.
}

