% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_spikes.R
\name{process_spikes}
\alias{process_spikes}
\title{QC, QA, and processing for a new spike database}
\usage{
process_spikes(fasta, methylated = 0, ...)
}
\arguments{
\item{fasta}{fasta file (or GRanges or DataFrame) w/spike sequences}

\item{methylated}{whether CpGs in each are methylated (0 or 1, default 0)}

\item{...}{additional arguments, e.g. kernels (currently unused)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{         a DataFrame suitable for downstream processing
}\if{html}{\out{</div>}}
}
\description{
Sequence feature verification: never trust anyone, least of all yourself.
}
\details{
GCfrac is the GC content of spikes as a proportion instead of a percent.
OECpG is (observed/expected) CpGs (expectation is 25\% of GC dinucleotides).
}
\examples{

data(spike)
spikes <- system.file("extdata", "spikes.fa", package="spiky", mustWork=TRUE)
spikemeth <- spike$methylated
process_spikes(spikes, spikemeth)

data(phage)
phages <- system.file("extdata", "phages.fa", package="spiky", mustWork=TRUE)
identical(process_spikes(phage), phage)
identical(phage, process_spikes(phage))

data(genbank_mito)
(mt <- process_spikes(genbank_mito)) # see also genbank_mito.R
gb_mito <- system.file("extdata", "genbank_mito.R", package="spiky")


}
\seealso{
kmers
}
