% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_rows.R
\name{scale_rows}
\alias{scale_rows}
\title{Centers and scales the rows of a numeric matrix.}
\usage{
scale_rows(x, center = TRUE, scale = TRUE, ...)
}
\arguments{
\item{x}{the matrix-like object}

\item{center}{Either a logical, character, or numeric-like value that
specifies what to center}

\item{scale}{Either a logical, characeter, or numeric-like value that
specifies what to scale}

\item{...}{pass through arguments}
}
\value{
a scaled version of \code{x}
}
\description{
This was for two reasons: (1) to avoid the (more commonly used)
\verb{t(scale(t(x), ...)} idiom; and (2) to specify what values, columns of x,
etc. to use to calculate means and sd's to use in the scaling function.
}
\details{
For instance, you might want to subtract the mean of a subset of columns
from each row in the matrix (like the columns that come from control samples)

Note that this method returns different attrs() for scaling and center
than base:scale does. Our values are always named.
}
\section{Transformation based on specific columns}{

\code{center} and \code{scale} can be a logical, character, or numeric-like vector.
The flexibility enables the following scenarios:
\enumerate{
\item The user can set it to \code{TRUE} to center all values on the mean of their
row. (\code{FALSE} does no centering)
\item A (named) vector of values that is a superset of rownames(x). These will
be the values that are subtracted from each row.
\item A logical vector as long as ncol(x). Each value will be centered to the
mean of the values of the columns specified as TRUE.
\item An integer vector, the is the analog of 3 but specifies the columns to
use for centering.
}
}

\examples{
# see tests/testthat/test-scale_rows.R for more examples
m <- matrix(rnorm(50, mean = 1, sd = 2), nrow = 5,
            dimnames = list(LETTERS[1:5], letters[1:10]))
s0 <- scale_rows(m, center = TRUE, scale = FALSE)
all.equal(s0, t(scale(t(m), center = TRUE, scale = FALSE)))

# mean center rows to a specific group of control samples (columns)
ctrl <- sample(colnames(m), 3)
s.ctrl <- scale_rows(m, center = ctrl, scale = FALSE)
ctrl.means <- Matrix::rowMeans(m[, ctrl])
all.equal(s.ctrl, t(scale(t(m), center = ctrl.means, scale = FALSE)))
}
