% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-interactive.R
\name{iplot}
\alias{iplot}
\title{Visualize gene level behavior of genes within a geneset across a contrast.}
\usage{
iplot(
  x,
  name,
  value = "logFC",
  type = c("density", "gsea", "boxplot"),
  tools = c("wheel_zoom", "box_select", "reset", "save"),
  main = NULL,
  with.legend = TRUE,
  collection = NULL,
  shiny_source = "mggenes",
  width = NULL,
  height = NULL,
  ggtheme = ggplot2::theme_bw(),
  trim = 0.005,
  ...
)
}
\arguments{
\item{x}{A \code{\link[=SparrowResult]{SparrowResult()}} object}

\item{name}{the name of the geneset to plot}

\item{value}{A string indicating the column name for the value of the
gene-level metadata to plot. Default is \code{"logFC"}. Anoter often used choice
might also be \code{"t"}, to plot t-statistics (if they're in the result). But
this can be any numeric column found in the data.frame returned by
\code{geneSet(x, y, j)}. If this is a named string (vector), then the value in
\code{names(value)} will be used on the axis when plotted.}

\item{type}{plot the distributions as a \code{"density"} plot or \code{"boxplot"}.}

\item{tools}{the tools to display in the rbokeh plot}

\item{main}{A title to display. If not specified, the gene set name
will be used, otherwise you can pass in a custom title, or \code{NULL}
will disable the title altogether.}

\item{with.legend}{Draws a legend to map point color to meaning. There are
three levels a point (gene level statistic) can be color as, "notsig",
"psig", and "sig". "notsig" implies that the FDR >= 10\%, "psig" means that
FDR <= 10\%, but the logFC is "unremarkable" (< 1), and "sig" means
that both the FDR <= 10\% and the logFC >= 1}

\item{collection}{If you have genesets with duplicate names in \code{x}
(only possible with a \code{GeneSetDb} object), provide the name of the
collection here to disambiguate (default: \code{NULL}).}

\item{shiny_source}{the name of this element that is used in shiny callbacks.
Defaults to \code{"mggenes"}.}

\item{width, height}{the width and height of the output plotly plot}

\item{ggtheme}{a ggplot theme, like the thing returned from
\code{ggplot2::theme_bw()}, for instance.}

\item{trim}{used to define the upper and lower quantiles to max out the
individual gene statistics in the selected geneset.}

\item{...}{pass through parameters to internal boxplot/density/gsea
plotting functions}
}
\value{
the ploty plot object
}
\description{
It is informative to look at the individual log fold changes of the genes
within a gene set to explore the degree to which they (1) are coherent with
respect to each other; and (2) see how the compare to the background
distribution of log fold changes of the entire transcriptome.

You can visualize this behavior via a \code{type = "density"} plot, or a
\verb{type = "boxplot". It is also common to plot either the individual log fold changes }value = "logFC"\verb{or t-statistics}value = "t"`.
}
\examples{
mgr <- exampleSparrowResult()
iplot(mgr, "BURTON_ADIPOGENESIS_PEAK_AT_2HR",
      value = c("t-statistic" = "t"),
      type = "density")
iplot(mgr, "BURTON_ADIPOGENESIS_PEAK_AT_2HR",
      value = c("log2FC" = "logFC"),
      type = "boxplot")
iplot(mgr, "BURTON_ADIPOGENESIS_PEAK_AT_2HR",
      value = c("-statistic" = "t"),
      type = "gsea")
}
