% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneSetDb-methods.R
\name{conversion}
\alias{conversion}
\alias{as.data.table.GeneSetDb}
\alias{as.data.frame}
\alias{as.list}
\alias{as.data.table}
\alias{as.data.frame.GeneSetDb}
\title{Convert a GeneSetDb to other formats.}
\usage{
\method{as.data.table}{GeneSetDb}(
  x,
  keep.rownames = FALSE,
  value = c("feature_id", "x.id", "x.idx"),
  active.only = is.conformed(x),
  ...
)

\method{as.data.frame}{GeneSetDb}(
  x,
  row.names = NULL,
  optional = NULL,
  value = c("feature_id", "x.id", "x.idx"),
  active.only = is.conformed(x),
  ...
)
}
\arguments{
\item{x}{A \code{GeneSetDb} object}

\item{keep.rownames}{included here just for consistency with
\code{data.table::as.data.table}, but it is not used}

\item{value}{The value type to export for the feature ids, defaults to
\code{"feature_id"}.}

\item{active.only}{If the \code{GeneSetDb} is conformed, do you want to only
return the features and genests that match target and are "active"?}

\item{...}{pass through arguments (not used)}

\item{row.names, optional}{included here for consistency with \code{as.data.frame}
generic function definition, but these are not used.}
}
\value{
a converted \code{GeneSetDb}
}
\description{
As awesome as a GeneSetDb is, you might find a time when you'll need your
gene set information in an other format. To do that, we provide the
following functions:
\itemize{
\item \verb{as(gdb, "BiocSetf')}: convert to a \code{\link[BiocSet:BiocSet-class]{BiocSet::BiocSet()}}.
\item \code{as(gdb, "GeneSetCollection")}: Convert to a
\code{\link[GSEABase:GeneSetCollection-methods]{GSEABase::GeneSetCollection()}} object.
\item \code{as.data.(table|frame)(gdb)}: Perhaps the most natural format to convert to in
order to save locally and examine outside of Bioconductor's GSEA universe,
but not many other tools accept gene set definitions in this format.
\item \code{as.list(gdb)}: A named list of feature identifiers. This is the format
that many of the limma gene set testing methods use
}
}
\details{
The \verb{as.*} functions accept a \code{value} parameter which indicates the type of
IDs you want to export in the conversion:
\itemize{
\item \code{"feature_id"}: The ID used as originally entered into the \code{GeneSetDb}.
\item \code{"x.idx"}: Only valid if the GeneSetDb \code{x} has been \code{conform}-ed to an
expession container. This option will export the features as the integer
rows of the expression container.
\item \code{"x.id"}: Only valid if the GeneSetDb \code{x} has been \code{conform}-ed. The
target expression container might use feature identifiers that are
different than what is in the GeneSetDb. If an active featureMap is
set on the GeneSetDb, this will convert the original feature identifiers
into a different target space (entrez to ensembl, for instance). Using
this option, the features will be provided in the target space.
}
}
\section{Functions}{
\itemize{
\item \code{as.data.frame(GeneSetDb)}: convert a GeneSetDb to data.frame

}}
\examples{
es <- exampleExpressionSet()
gdb <- conform(exampleGeneSetDb(), es)
bs <- as(gdb, "BiocSet")
gdf <- as.data.frame(gdb)
gdb <- conform(gdb, es)
gdfi <- as.data.frame(gdb, value = 'x.idx')
gdl <- as.list(gdb)
}
