% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotAllWeights}
\alias{plotAllWeights}
\title{Plot pie charts of cell type proportions across pixels}
\usage{
plotAllWeights(
  rctd_spe,
  assay_name = "weights",
  cell_type_colors = NA,
  r = 0.4,
  lwd = 1,
  title = NA
)
}
\arguments{
\item{rctd_spe}{\code{\link[SpatialExperiment]{SpatialExperiment}} object
containing RCTD results}

\item{assay_name}{character, name of the assay to plot
(default: \code{"weights"})}

\item{cell_type_colors}{vector of colors for the different cell types
(default: rainbow)}

\item{r}{numeric, radius of the pie charts (default: 0.4)}

\item{lwd}{numeric, line width of the pie chart borders (default: 1)}

\item{title}{character, plot title (default: \code{NA})}
}
\value{
\code{ggplot} object showing cell type proportions at each pixel
  using pie charts
}
\description{
Generates a visualization where each pixel is represented by a pie chart
showing the proportions of different cell types at that location. Users
should run this function on the result of \code{\link{runRctd}}.
}
\details{
This function is adapted from \code{vizAllTopics} in the \code{STdeconvolve}
package.
}
\examples{
data(rctdSim)

# In practice, results_spe should contain the results of an RCTD run.
results_spe <- rctdSim$proportions_spe
plotAllWeights(
    results_spe, r = 0.05, lwd = 0.5, title = "Cell Type Proportions"
)

}
