% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_query_functions.R
\name{query_jx}
\alias{query_jx}
\alias{query_gene}
\alias{query_exon}
\title{Query Junctions/Genes/Exons}
\usage{
query_jx(sb, return_rse = TRUE, split_by_region = FALSE)

query_gene(sb, return_rse = TRUE, split_by_region = FALSE)

query_exon(sb, return_rse = TRUE, split_by_region = FALSE)
}
\arguments{
\item{sb}{A SnaptronQueryBuilder object}

\item{return_rse}{Should the query data be returned as a simple data frame or
converted to a RangedSummarizedExperiment.}

\item{split_by_region}{By default the results from multiple queries will be
returned in a \code{RangedSummarizedExperiment} object with a \code{rowData} entry for
each, labeling each result row according to the query it resulted
from. However, if this is set to \code{TRUE}, the result will be a list of
RangedSummarizedExperiment objects, one per original interval/gene. This
latter option may be useful, but it requires a separate copy of the sample
metadata for each original interval/gene.}
}
\value{
Functions will return either a RangedSummarizedExperiment or
data.table depending on whether the \code{return_rse} parameter is set to
\code{TRUE} or \code{FALSE}.
}
\description{
Given one or more gene names or genomic range
intervals it will return a list of 0 or more genes, junctions, or exons
(depending on which query form is used) which overlap the ranges.
}
\examples{
# Contruct a QueryBuilder object
qb <- QueryBuilder(compilation = "gtex", regions = "chr1:1-100000")
qb <- set_row_filters(qb, samples_count >= 20)
query_jx(qb)

qb <- set_row_filters(qb, NULL)
qb <- set_column_filters(qb, SMTS == "Brain")
query_gene(qb)

}
