% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{sin_score_boxplot}
\alias{sin_score_boxplot}
\title{boxplot of split single feature score}
\usage{
sin_score_boxplot(data, features = NULL, ref.group, label, method = "t.test")
}
\arguments{
\item{data}{matrix, features in row and samples in column}

\item{features}{vector, feature names to plot}

\item{ref.group}{character, reference group name}

\item{label}{vector, group labels}

\item{method}{character, statistical test to use,
details in \code{\link[ggpubr:stat_compare_means]{ggpubr::stat_compare_means()}}}
}
\value{
faceted ggplot object
}
\description{
boxplot of split single feature score
}
\examples{
data <- matrix(rnorm(100), 10, dimnames = list(1:10))
sin_score_boxplot(data, 1:2, ref.group = "A", label = rep(c("A", "B"), 5))
}
