% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/score-methods.R
\name{cal_score}
\alias{cal_score}
\alias{cal_score,AnyMatrix-method}
\alias{cal_score,SummarizedExperiment-method}
\title{calculate combined score}
\usage{
cal_score(
  data,
  tf = c("logtf", "tf"),
  idf = "prob",
  iae = "prob",
  slot = "counts",
  new.slot = "score",
  par.idf = NULL,
  par.iae = NULL
)

\S4method{cal_score}{AnyMatrix}(
  data,
  tf = c("logtf", "tf"),
  idf = "prob",
  iae = "prob",
  par.idf = NULL,
  par.iae = NULL
)

\S4method{cal_score}{SummarizedExperiment}(
  data,
  tf = c("logtf", "tf"),
  idf = "prob",
  iae = "prob",
  slot = "counts",
  new.slot = "score",
  par.idf = NULL,
  par.iae = NULL
)
}
\arguments{
\item{data}{an expression object, can be matrix or SummarizedExperiment}

\item{tf}{a character, specify the TF method to use, can be "tf" or "logtf"}

\item{idf}{a character, specify the IDF method to use. Available methods can
be accessed using \code{\link[=idf_iae_methods]{idf_iae_methods()}}}

\item{iae}{a character, specify the IAE method to use. Available methods can
be accessed using \code{\link[=idf_iae_methods]{idf_iae_methods()}}}

\item{slot}{a character, specify which slot to use when data is se object,
optional, default 'counts'}

\item{new.slot}{a character, specify the name of slot to save score in se object,
optional, default 'score'}

\item{par.idf}{other parameters for specified IDF methods}

\item{par.iae}{other parameters for specified IAE methods}
}
\value{
A list of matrices or se object containing combined score
}
\description{
compute TF (term/feature frequency), IDF (inverse document/cell
frequency), IAE (inverse average expression of features) and combine the
the final score
}
\examples{
data <- matrix(rpois(100, 2), 10, dimnames = list(1:10))
cal_score(
  data,
  par.idf = list(label = sample(c("A", "B"), 10, replace = TRUE)),
  par.iae = list(label = sample(c("A", "B"), 10, replace = TRUE))
)
}
