% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractSite.R
\name{extractSite}
\alias{extractSite}
\alias{extractSite.fixationSites}
\title{Extract tips for a single site}
\usage{
extractSite(x, site, ...)

\method{extractSite}{fixationSites}(x, site, ...)
}
\arguments{
\item{x}{A \code{fixationSites} or a \code{parallelSites} object. More type
will be supported in the later version.}

\item{site}{A site included in the result.}

\item{...}{Other arguments}
}
\value{
The predicted result of a single site
}
\description{
The functions in \code{sitePath} usually include the results on
  more than one site. The function \code{extractSite} can be used to extract
  the predicted result on a single site.
}
\examples{
data(zikv_tree_reduced)
data(zikv_align_reduced)
tree <- addMSA(zikv_tree_reduced, alignment = zikv_align_reduced)
mutations <- fixationSites(lineagePath(tree))
extractSite(mutations, 139)
}
