% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runTSCAN.R
\name{plotTSCANClusterPseudo}
\alias{plotTSCANClusterPseudo}
\title{Plot TSCAN pseudotime rooted from given cluster}
\usage{
plotTSCANClusterPseudo(
  inSCE,
  useCluster,
  useReducedDim = "UMAP",
  combinePlot = c("all", "none")
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{useCluster}{The cluster to be regarded as the root, has to existing in
\code{colData(inSCE)$TSCAN_clusters}.}

\item{useReducedDim}{Saved dimension reduction name in the
SingleCellExperiment object. Required.}

\item{combinePlot}{Must be either \code{"all"} or \code{"none"}. \code{"all"}
will combine plots of pseudotime along each path into a single \code{.ggplot}
object, while \code{"none"} will output a list of plots. Default
\code{"all"}.}
}
\value{
\item{combinePlot = "all"}{A \code{.ggplot} object}
\item{combinePlot = "none"}{A list of \code{.ggplot}}
}
\description{
This function finds all paths that root from a given cluster
\code{useCluster}. For each path, this function plots the recomputed
pseudotime starting from the root on a scatter plot which contains cells only
in this cluster. MST has to be pre-calculated with \code{\link{runTSCAN}}.
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
mouseBrainSubsetSCE <- runTSCAN(inSCE = mouseBrainSubsetSCE,
                                useReducedDim = "PCA_logcounts")
plotTSCANClusterPseudo(mouseBrainSubsetSCE, useCluster = 1,
                       useReducedDim = "TSNE_logcounts")
}
\author{
Nida Pervaiz
}
