% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDEAnalysis.R
\name{plotMASTThresholdGenes}
\alias{plotMASTThresholdGenes}
\title{MAST Identify adaptive thresholds}
\usage{
plotMASTThresholdGenes(
  inSCE,
  useAssay = "logcounts",
  doPlot = TRUE,
  isLogged = TRUE,
  check_sanity = TRUE
)
}
\arguments{
\item{inSCE}{SingleCellExperiment object}

\item{useAssay}{character, default \code{"logcounts"}}

\item{doPlot}{Logical scalar. Whether to directly plot in the plotting area.
If \code{FALSE}, will return a graphical object which can be visualized with
\code{grid.draw()}. Default \code{TRUE}.}

\item{isLogged}{Logical scalar. Whether the assay used for the analysis is
logged. If not, will do a \code{log(assay + 1)} transformation. Default
\code{TRUE}.}

\item{check_sanity}{Logical scalar. Whether to perform MAST's sanity check
to see if the counts are logged. Default \code{TRUE}}
}
\value{
Plot the thresholding onto the plotting region if \code{plot == TRUE}
or a graphical object if \code{plot == FALSE}.
}
\description{
Calculate and produce a list of thresholded counts (on natural scale),
thresholds, bins, densities estimated on each bin, and the original data from
\code{\link[MAST]{thresholdSCRNACountMatrix}}
}
\examples{
data("mouseBrainSubsetSCE")
plotMASTThresholdGenes(mouseBrainSubsetSCE)
}
