% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbb-step1-fit.R
\name{wilcox_CIP_GIP}
\alias{wilcox_CIP_GIP}
\title{Mann-Whitney Wilcoxon test p-value}
\usage{
wilcox_CIP_GIP(ref_distr, null_distr, ...)
}
\arguments{
\item{ref_distr}{A vector with the reference distribution}

\item{null_distr}{A vector with the null distribution}

\item{...}{Other parameters to be passed onto wilcox.test}
}
\value{
A pvalue with the Mann-Whitney Wilcoxon test with the "greater" as the
alternative hypothesis
}
\description{
Mann-Whitney Wilcoxon test p-value
}
\examples{
ref_distr <- rnorm(100, mean = 30, sd = 2)
null_distr <- rnorm(100, mean = 0, sd = 1)
wilcox_CIP_GIP(ref_distr, null_distr)
}
