% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{update_group_sizes}
\alias{update_group_sizes}
\title{Update block‐size vector after cleaning}
\usage{
update_group_sizes(group_orig, keep_cols)
}
\arguments{
\item{group_orig}{Integer vector of original block sizes (sum group_orig =
ncol before cleaning).}

\item{keep_cols}{Logical vector of length \code{sum(group_orig)}, \code{TRUE}
for columns retained.}
}
\value{
Integer vector of same length as \code{group_orig} with updated block
sizes.
}
\description{
Given an original vector of block lengths and a mask of kept
columns, recomputes the new block lengths.
}
\examples{
update_group_sizes(c(2,3), c(TRUE, TRUE, FALSE, TRUE, TRUE))
}
