% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step2-biologicalLink.R
\name{singIST_treat}
\alias{singIST_treat}
\title{Derive singIST treated samples}
\usage{
singIST_treat(object, model_object, orthologs, logFC)
}
\arguments{
\item{object}{A mapping organism list passed from
\link{biological_link_function}.}

\item{model_object}{A superpathway fit model list passed from
\link{biological_link_function}}

\item{orthologs}{A list of \code{data.table} objects, as returned by
\link{orthology_mapping} with the one-to-one orthologs of each gene set per
cell type}

\item{logFC}{A list of \code{data.frame} objects, as returned by
\link{diff_expressed} with the logFC for each gene and cell type.}
}
\value{
A list object with the singIST treated samples predictor block matrix and
a list of Fold Changes for each cell type used to compute the singIST
treated samples.
}
\description{
Derive singIST treated samples
}
\examples{
# Orthology mapping
file <- system.file("extdata", "example_mapping_organism.rda",
package = "singIST")
load(file)
data_organism <- example_mapping_organism
file <- system.file("extdata", "example_superpathway_fit_model.rda",
package = "singIST")
load(file)
data_model <- example_superpathway_fit_model
orthologs <- orthology_mapping(data_organism, data_model, "hsapiens")
# Set the identities
# Cell type mapping
data <- celltype_mapping(data_organism)
data$counts$test <- paste0(data$counts$celltype_cluster, 
"_", data$counts$class)
SeuratObject::Idents(data$counts) <- "test"
logFC <- diff_expressed(data)
\donttest{singIST_treat(data_organism, data_model, orthologs, logFC)}
}
