% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-wrappers.R
\name{multiple_check}
\alias{multiple_check}
\title{Check if parameter format is consistent}
\usage{
multiple_check(parameter, objectLength)
}
\arguments{
\item{parameter}{The parameters passed from either
\link{multiple_fitOptimal} or \link{multiple_singISTrecapitulations}}

\item{objectLength}{The number of objects that the wrapper functions
iterate on}
}
\value{
A list with the repetition of the parameter
}
\description{
For the wrapper functions \link{multiple_fitOptimal} and
\link{multiple_singISTrecapitulations} one must pass multiple parameters. To
check for the consistency of such parameters we use this function with the
logic; if the parameter passed is \code{NULL} or its length is 1, it is assumed
that the desired list of parameters is the repetition of such; if the
parameter passed is a vector whose length is the number of objects that
the wrappers iterate on, then the function returns a list whose elements
are each of the vector elements; otherwise if the parameters are a vector
whose length does not match with the number of objects to iterate on
then the function stops
}
\examples{
# NULL parameter case
parameter <- NULL
objectLength <- 10
multiple_check(parameter, objectLength)

# Parameter equal for all elements
parameter <- FALSE
objectLength <- 5
multiple_check(parameter, objectLength)

# Parameter differing for all elements
parameter <- c(1, 6, 7, 8, 9)
objectLength <- 5
multiple_check(parameter, objectLength)
}
