% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{fit_mfa_imputer}
\alias{fit_mfa_imputer}
\title{Fit a multiblock‐MFA imputer on training data}
\usage{
fit_mfa_imputer(X_train, group, ncp = 2, method = "Regularized")
}
\arguments{
\item{X_train}{Numeric matrix (train samples × features), may contain NAs.}

\item{group}{Integer vector of block sizes (must sum to
\code{ncol(X_train)}).}

\item{ncp}{Number of MFA components to use for imputation (default \code{2}).}

\item{method}{Method for \code{imputeMFA()}: \code{"Regularized"} or
\code{"EM"}.}
}
\value{
A list with components:
\describe{
\item{\code{imputed}}{Matrix \code{X_train} with NAs filled.}
\item{\code{mu}}{Numeric vector of column means (length = ncol).}
\item{\code{loadings}}{Numeric matrix of loadings (ncol × ncp).}
}
}
\description{
Runs a full EM‐based \code{imputeMFA()} on the training set
then fits a pure MFA to extract the final means and loadings.
}
\examples{
fit_mfa_imputer(matrix(c(NA,runif(19)), nrow = 5, ncol = 4), c(2,2))
}
