% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-all-input.R
\name{create_fit_model}
\alias{create_fit_model}
\title{Create superpathway fit model object}
\usage{
create_fit_model(
  superpathway_input,
  hyperparameters_fit,
  model_fit,
  model_validation
)
}
\arguments{
\item{superpathway_input}{List. A superpathway object created by create_superpathway().}

\item{hyperparameters_fit}{List. A hyperparameters object created by create_hyperparameters().}

\item{model_fit}{List. Fitted model details.}

\item{model_validation}{List. Validation metrics of the fitted model.}
}
\value{
A list with elements: superpathway_input, hyperparameters_fit, model_fit, model_validation.
}
\description{
Creates a simple list representing a fitted asmbPLS-DA model, after validating its components.
}
\examples{
my_pathway <- create_pathway("KEGG_CYTOKINE_CYTOKINE_RECEPTOR_INTERACTION",
"KEGG", "c2", "CP")

celltypes <- c("T-cell", "Dendritic Cell")

my_superpathway <- create_superpathway(my_pathway, celltypes,
list(c("IL4", "IL5"), c("IL13")))

my_hyperparameters <- create_hyperparameters(matrix(1:4, nrow = 2), "binary",
3L, 5L, 10L)

#' # ---- Pseudobulk + labels ----
sample_id <- c("AD1", "AD2", "HC1", "HC2")
sample_class <- c("AD", "AD", "HC", "HC")
base_class <- "HC"
target_class <- "AD"

pseudobulk_lognorm <- matrix(
  rnorm(length(celltypes) * length(sample_id)),
  nrow = length(celltypes) * length(sample_id),
  ncol = length(celltypes)
)
rownames(pseudobulk_lognorm) <- as.vector(t(outer(
  celltypes, sample_id, function(x, y) paste(x, y, sep = "_")
)))

my_superpathway_input <- create_superpathway_input(
    superpathway_info = my_superpathway,
    hyperparameters_info = my_hyperparameters,
    pseudobulk_lognorm = pseudobulk_lognorm,
    sample_id = sample_id,
    sample_class = sample_class,
    base_class = base_class,
    target_class = target_class
    )
my_fit <- create_fit_model(my_superpathway_input, my_hyperparameters,
list(model = "fit"), list(accuracy = 0.95))
}
