% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-all-input.R
\name{check_pathway}
\alias{check_pathway}
\title{Validate pathway fields}
\usage{
check_pathway(standard_name, dbsource, collection, subcollection)
}
\arguments{
\item{standard_name}{Character. Pathway standard name from MsigDB.}

\item{dbsource}{Character. Database source (KEGG, PID, REACTOME, BIOCARTA, WIKIPATHWAYS).}

\item{collection}{Character. MsigDB collection (c2 or m2).}

\item{subcollection}{Character. MsigDB subcollection (CP).}
}
\value{
TRUE if all checks pass; otherwise, an error is thrown.
}
\description{
Checks that all provided fields for a pathway meet the expected properties.
}
\examples{
check_pathway(
  standard_name = "KEGG_CYTOKINE_CYTOKINE_RECEPTOR_INTERACTION",
  dbsource = "KEGG",
  collection = "c2",
  subcollection = "CP"
)
}
