% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-all-input.R
\name{check_mapping_organism}
\alias{check_mapping_organism}
\title{Validate mapping organism input}
\usage{
check_mapping_organism(
  organism,
  target_class,
  base_class,
  celltype_mapping,
  counts
)
}
\arguments{
\item{organism}{Character(1). Scientific Latin name of the organism.}

\item{target_class}{Character(1). Name of the target class for this organism.}

\item{base_class}{Character(1). Name of the base class for this organism.}

\item{celltype_mapping}{List. Mapping of cell types (keys) to cluster names (character vectors).}

\item{counts}{Seurat or SingleCellExperiment. Contains scRNA-seq counts and metadata.}
}
\value{
TRUE if all checks pass; otherwise an informative error is thrown.
}
\description{
Validates that all provided fields for a mapping organism meet expected properties:
\itemize{
\item organism, target_class, base_class are scalar characters.
\item celltype_mapping is a list with non-empty names; each entry is a character vector (length 0 allowed).
\item counts is a Seurat or SingleCellExperiment object with metadata columns: 'class' and 'celltype_cluster'.
\item target_class and base_class exist in meta$class and are different (after normalization).
\item all clusters referenced in celltype_mapping exist in meta$celltype_cluster.
}
}
\examples{
# Seurat example
counts <- SeuratObject::pbmc_small
colnames(slot(counts, "meta.data"))[1] <- "donor"
colnames(slot(counts, "meta.data"))[6] <- "class"
colnames(slot(counts, "meta.data"))[7] <- "celltype_cluster"
celltype_mapping <- list("T-cell" = c("T"), "Dendritic Cell" = character(0))
check_mapping_organism("Mus musculus", "g1", "g2", celltype_mapping, counts)
}
