% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-all-input.R
\name{check_hyperparameters}
\alias{check_hyperparameters}
\title{Validate asmbPLS-DA hyperparameters}
\usage{
check_hyperparameters(
  quantile_comb_table,
  outcome_type,
  number_PLS,
  folds_CV,
  repetition_CV
)
}
\arguments{
\item{quantile_comb_table}{Matrix. Quantile (lambda) sparsity values for CV.}

\item{outcome_type}{Character. Either "binary" or "multiclass".}

\item{number_PLS}{Integer. Maximum number of PLS components.}

\item{folds_CV}{Integer or NULL. Number of folds for CV (default 5).}

\item{repetition_CV}{Integer or NULL. Number of repetitions for CV (default 10).}
}
\value{
TRUE if all checks pass; otherwise, an error is thrown.
}
\description{
Checks that all provided hyperparameters meet the expected properties:
\itemize{
\item quantile_comb_table must be a matrix with at least one row.
\item outcome_type must be "binary" or "multiclass".
\item number_PLS must be an integer >= 0.
\item folds_CV and repetition_CV must be integers >= 0 (or NULL).
}
}
\examples{
quantile_comb_table <- base::as.matrix(RcppAlgos::permuteGeneral(seq(0.05,
0.95, by = 0.50)))
check_hyperparameters(quantile_comb_table, "binary", 3L, 1L, 1L)
}
