% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricsMethods.R
\name{diffPosMaxMethod}
\alias{diffPosMaxMethod}
\title{Difference between two profiles maximal peaks positions}
\usage{
diffPosMaxMethod(profile1, profile2, threshold = 1, thresholdDist = 100,
  tolerance = 0.01)
}
\arguments{
\item{profile1}{a \code{vector} of \code{numeric} values, the first profile
containing the alignment depth for each position. The \code{profile1} and 
\code{profile2} should have the same length.}

\item{profile2}{a \code{vector} of \code{numeric} values, the second profile
containing the alignment depth for each position. The \code{profile1} and 
\code{profile2} should have the same length.}

\item{threshold}{a \code{numeric}, the minimum peak value accepted to 
calculate the metric. Default = 1.}

\item{thresholdDist}{a \code{numeric}, the maximum distance accepted 
between two maximum peaks positions in the same profile. Default = 100.}

\item{tolerance}{a \code{numeric}, the maximum variation accepted on the 
maximum value to consider a position as a peak position. The tolerance must}
}
\value{
The calculated ratio or \code{NA} if not all thresholds are 
respected.
}
\description{
Calculate and return the difference between two profiles 
maximal peaks positions. The difference is always the first profile value 
(profile1 parameter) minus the second profile value (profile2 parameter). 
When more than one maximual peak is present in one profile, the mediane of
the position is calculated and used as the maximal peak position.
If one threshold is not respected, the function returns \code{NA}.
}
\seealso{
\itemize{
\item \code{\link{MetricFactory}} {for using the recommanded interface to 
calculate all available metrics separately or togheter.}
}
}
\author{
Astrid Deschenes, Elsa Bernatchez
}
