% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oraAnalyzer.R
\name{enrichKEGG2}
\alias{enrichKEGG2}
\title{KEGG Pathway Enrichment with Hypergeometric Test}
\usage{
enrichKEGG2(
  gene,
  organism = "hsa",
  keyType = "kegg",
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe,
  minGSSize = 5,
  maxGSSize = 500,
  qvalueCutoff = 0.2,
  readable = FALSE
)
}
\arguments{
\item{gene}{a vector of entrez gene ids (here the test set)}

\item{organism}{supported organism are listed in 
http://www.genome.jp/kegg/catalog/org_list.html}

\item{keyType}{one of "kegg", 'ncbi-geneid', 'ncbi-proteinid' or 'uniprot'}

\item{pvalueCutoff}{pvalue cutoff}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni", 
"BH", "BY", "fdr", "none"}

\item{universe}{background genes}

\item{minGSSize}{minimal size of genes annotated by 
ontology term for testing.}

\item{maxGSSize}{maximal size of genes annotated for testing}

\item{qvalueCutoff}{qvalue cutoff}

\item{readable}{TRUE or FALSE indicating whether to convert gene Entrez ids
to gene Symbols in the 'itemID' column in the FEA result table.}
}
\value{
A \code{feaResult} instance.
}
\description{
Given a vector of gene identifiers, this function returns KEGG pathway 
enrichment results based on a hypergeometric test with duplication support 
in the test set.
}
\examples{
# Method supports duplicated elements in "gene", which should be entrez ids
gene <- c(rep("4312",4), rep("8318",2), "991", "10874")
#data(geneList, package="DOSE")
#kk <- enrichKEGG2(gene = gene, universe=names(geneList))
#head(kk)
}
