% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statFDR.R
\name{statFDR}
\alias{statFDR}
\title{FDR control}
\usage{
statFDR(testMatrix, ctrlMethod = "smoother", ...)
}
\arguments{
\item{testMatrix}{Data frame or numeric matrix consisting of output from \code{\link{statT}} or \code{\link{statRVM}} functions. P-value columns from this matrix are automatically selected for FDR calculation. Columns are samples, and rows are plate wells.}

\item{ctrlMethod}{Optional. Method to use either 'smoother' or 'bootstrap' to estimate null. Default is 'smoother'.}

\item{...}{Optional. Additional parameters passed to \code{\link[qvalue]{qvalue}} function.}
}
\value{
A matrix of parameters for each replicate group is returned:
\item{T-statistic or RVM T-statistic}{Value of the t-statistic.}
\item{Mean_Difference}{Difference between the calculated and the true mean.}
\item{Standard_Error}{Standard error of the difference between means.}
\item{Degrees_Of_Freedom}{Degrees of freedom for the t-statistic.}
\item{P-value}{P-value for the t-test.}
\item{q-value}{FDR q-value for the P-value.}
}
\description{
Apply Storey's FDR control to p-values
}
\details{
False Discovery Rate procedure is used to control the proportion of false positives in the results. This is an implementation of the positive false discovery (pFDR) procedure of the \code{\link[qvalue]{qvalue}} function.
}
\note{
Please install the package 'qvalue' from Bioconductor, if not already installed.
}
\examples{
## load dataset
data(ex_dataMatrix)

## normalize data matrix using any method and store in new variable
ex_normMatrix <- normSights(dataMatrix = ex_dataMatrix, dataCols = 5:10,
normMethod = 'normZ')
## test normalized data matrix using either the RVM or T test and store in new variable
ex_testMatrix <- statT(normMatrix = ex_normMatrix, trueMean = 0,
repIndex = c(1,1,1,2,2,2))
## apply FDR control to test matrix with bootstrap control method
ex_ctrlMatrix <- statFDR(testMatrix = ex_testMatrix,
ctrlMethod = 'bootstrap')

}
\references{
\href{http://onlinelibrary.wiley.com/doi/10.1111/1467-9868.00346/pdf}{Storey (2002). A direct approach to false discovery rates. Journal of the Royal Statistical Society: Series B, 64, 479-498.}
}
\seealso{
Other statistical methods: \code{\link{statRVM}},
  \code{\link{statT}}
}

