% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-uploader.R
\name{cli_upload}
\alias{cli_upload}
\alias{misc_upload_cli}
\title{Upload files using Seven Bridges command line uploader}
\usage{
cli_upload(
  token = NULL,
  uploader = NULL,
  file = NULL,
  project = NULL,
  proxy = NULL,
  tag = NULL,
  manifest_file = NULL,
  manifest_metadata = c("all", "none", "partial"),
  metadata_fields = NULL,
  dry_run = FALSE,
  dry_run_fields = NULL
)

misc_upload_cli()
}
\arguments{
\item{token}{Authentication token.}

\item{uploader}{The directory where the command line uploader
is located (the directory that contains the \code{bin/} directory).}

\item{file}{The location of the (single) file to upload. To upload multiple
files, please use \code{manifest_file} to specify.}

\item{project}{The project identifier (e.g. \code{username/project-name})
to upload files to. This option is mandatory. To upload files to a project,
you must be a member of that project and must have the write permission
granted by the project administrator.}

\item{proxy}{A proxy server through which the uploader should connect.
For details the proxy parameter format, see the part on parameter
\code{--proxy} in the reference below.}

\item{tag}{Tags for your the files (optional). Use a vector of
character strings, for instance, \code{c("tag one", "the second tag")}.}

\item{manifest_file}{Location of the manifest file (for uploading
multiple files with metadata). See the reference URL below for the
format of a manifest file.}

\item{manifest_metadata}{Should we use all, none, or only a part of the
the metadata fields included in the manifest file? Default is \code{"all"}.}

\item{metadata_fields}{Character vector, the metadata fields to use
in the manifest file. This should be specified if and only if
\code{manifest_metadata = "partial"}.}

\item{dry_run}{Should we just output the data and check the settings
without uploading anything? Default is \code{FALSE}.}

\item{dry_run_fields}{Character vector, specific metadata fields
to output information about when \code{dry_run = TRUE}.}
}
\value{
The uploaded file's ID number.
}
\description{
Upload files using Seven Bridges command line uploader.
}
\note{
To use the command line uploader, Java 1.7 or newer
should be installed. See the reference link below for details.
}
\examples{
token <- "your_token"
\dontrun{
cli_upload(
  token = token,
  uploader = "~/Downloads/cgc-uploader/",
  file = "~/example.fastq", project = "username/project-name"
)}
}
\references{
Seven Bridges Command Line Uploader:
\url{https://docs.sevenbridges.com/docs/upload-via-the-command-line}
Manifest file format:
\url{https://docs.sevenbridges.com/docs/format-of-a-manifest-file}
}
\seealso{
See \code{\link{get_uploader}} for downloading
the command line uploader for Seven Bridges platforms.
See \code{\link{cli_list_projects}} and \code{\link{cli_list_tags}}
for listing available projects or tags with the command line uploader.
}
